<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title inertia><?php echo e(app_name() ?? 'Restart'); ?> - Admin App</title>

    <!-- App favicon -->
    <!-- <link rel="shortcut icon" href="<?php echo e(URL::asset('image/favicon.ico')); ?>"> -->
    <link rel="shortcut icon" id="dynamic-favicon" href="">

 <!-- Firebase SDK -->
<!-- Use the Firebase 8.x version for CommonJS support -->
<script src="https://www.gstatic.com/firebasejs/8.10.0/firebase-app.js"></script>
<script src="https://www.gstatic.com/firebasejs/8.10.0/firebase-database.js"></script>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/js/select2.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/driver.js@1.0.1/dist/driver.js.iife.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/driver.js@1.0.1/dist/driver.css"/>


    <?php
        $default_language = default_language();
    ?>
    <script>

        window.defaultLocale = "<?php echo e($default_language->code); ?>";
        window.direction = "<?php echo e($default_language->direction); ?>";

    </script>
    <!-- Scripts -->
    <?php echo app('Tightenco\Ziggy\BladeRouteGenerator')->generate(); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/app.js', "resources/js/Pages/{$page['component']}.vue"]); ?>
    <?php if (!isset($__inertiaSsrDispatched)) { $__inertiaSsrDispatched = true; $__inertiaSsrResponse = app(\Inertia\Ssr\Gateway::class)->dispatch($page); }  if ($__inertiaSsrResponse) { echo $__inertiaSsrResponse->head; } ?>

</head>

<body>
    <?php if (!isset($__inertiaSsrDispatched)) { $__inertiaSsrDispatched = true; $__inertiaSsrResponse = app(\Inertia\Ssr\Gateway::class)->dispatch($page); }  if ($__inertiaSsrResponse) { echo $__inertiaSsrResponse->body; } else { ?><div id="app" data-page="<?php echo e(json_encode($page)); ?>"></div><?php } ?>
    <script>
        window.headers = <?php echo json_encode($headers, 15, 512) ?>;
        window.recaptchaKey = <?php echo json_encode(config('services.recaptcha.site_key'), 15, 512) ?>;
        window.enablerecaptcha = <?php echo json_encode(config('services.recaptcha.enable_recapcha'), 15, 512) ?>;
        window.logo =  <?php echo json_encode($logo, 15, 512) ?>;
        window.favicon =  <?php echo json_encode($favicon, 15, 512) ?>;
        window.footer_content1 = <?php echo json_encode($footer_content1, 15, 512) ?>;
        window.supportTicket = <?php echo json_encode($supportTicket, 15, 512) ?>;
        window.footer_content2 = <?php echo json_encode($footer_content2, 15, 512) ?>;
        window.agent_addons = <?php echo json_encode($agent_addons, 15, 512) ?>;
        window.admin_url = <?php echo json_encode($admin_url, 15, 512) ?>;
        window.user_url = <?php echo json_encode($user_url, 15, 512) ?>;
        window.owner_url = <?php echo json_encode($owner_url, 15, 512) ?>;
        window.dispatch_url = <?php echo json_encode($dispatch_url, 15, 512) ?>;
        window.agent_url = <?php echo json_encode($agent_url, 15, 512) ?>;
        window.dispatch_pro_url = <?php echo json_encode($dispatch_pro_url, 15, 512) ?>;

    </script>
</body>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Check if window.favicon is available and set it dynamically
        if (window.favicon) {
            document.getElementById('dynamic-favicon').setAttribute('href', window.favicon);
        } else {
            // Fallback if the favicon is not set
            document.getElementById('dynamic-favicon').setAttribute('href', '<?php echo e(URL::asset("image/favicon.ico")); ?>');
        }
    });
</script>
<style>
:root{
    --top_nav: <?php echo e($navs -> value); ?>;
    --side_menu: <?php echo e($side -> value); ?>;
    --side_menu_txt: <?php echo e($side_txt -> value); ?>;
    --loginbg: url('<?php echo e($loginbg); ?>');
    --owner_loginbg: url('<?php echo e($owner_loginbg); ?>');
    --landing_header_bg: <?php echo e($landing_header_bg_color -> value); ?>;
    --landing_header_text: <?php echo e($landing_header_text_color -> value); ?>;
    --landing_header_act_text: <?php echo e($landing_header_active_text_color -> value); ?>;
    --landing_footer_bg: <?php echo e($landing_footer_bg_color -> value); ?>;
    --landing_footer_text: <?php echo e($landing_footer_text_color -> value); ?>;
    --dispatcher_sidebar_color: <?php echo e($dispatcher_sidebar_color -> value); ?>;
    --dispatcher_sidebar_txt_color: <?php echo e($dispatcher_sidebar_txt_color -> value); ?>;
}
</style>

</html>
<?php /**PATH /www/wwwroot/kurknu.com/resources/views/app.blade.php ENDPATH**/ ?>