/// <reference types="google.maps" />
import { PropType } from "vue";
import { Library } from "@googlemaps/js-api-loader";
declare const _default: import("vue").DefineComponent<{
    apiPromise: {
        type: PropType<Promise<typeof google>>;
    };
    apiKey: {
        type: StringConstructor;
        default: string;
    };
    version: {
        type: StringConstructor;
        default: string;
    };
    libraries: {
        type: PropType<Library[]>;
        default: () => string[];
    };
    region: {
        type: StringConstructor;
        required: false;
    };
    language: {
        type: StringConstructor;
        required: false;
    };
    backgroundColor: {
        type: StringConstructor;
        required: false;
    };
    center: {
        type: PropType<google.maps.LatLng | google.maps.LatLngLiteral>;
        default: () => {
            lat: number;
            lng: number;
        };
    };
    clickableIcons: {
        type: BooleanConstructor;
        required: false;
        default: undefined;
    };
    controlSize: {
        type: NumberConstructor;
        required: false;
    };
    disableDefaultUi: {
        type: BooleanConstructor;
        required: false;
        default: undefined;
    };
    disableDoubleClickZoom: {
        type: BooleanConstructor;
        required: false;
        default: undefined;
    };
    draggable: {
        type: BooleanConstructor;
        required: false;
        default: undefined;
    };
    draggableCursor: {
        type: StringConstructor;
        required: false;
    };
    draggingCursor: {
        type: StringConstructor;
        required: false;
    };
    fullscreenControl: {
        type: BooleanConstructor;
        required: false;
        default: undefined;
    };
    fullscreenControlPosition: {
        type: PropType<"BOTTOM_CENTER" | "BOTTOM_LEFT" | "BOTTOM_RIGHT" | "LEFT_BOTTOM" | "LEFT_CENTER" | "LEFT_TOP" | "RIGHT_BOTTOM" | "RIGHT_CENTER" | "RIGHT_TOP" | "TOP_CENTER" | "TOP_LEFT" | "TOP_RIGHT">;
        required: false;
    };
    gestureHandling: {
        type: PropType<"none" | "cooperative" | "greedy" | "auto">;
        required: false;
    };
    heading: {
        type: NumberConstructor;
        required: false;
    };
    isFractionalZoomEnabled: {
        type: BooleanConstructor;
        required: false;
        default: undefined;
    };
    keyboardShortcuts: {
        type: BooleanConstructor;
        required: false;
        default: undefined;
    };
    mapTypeControl: {
        type: BooleanConstructor;
        required: false;
        default: undefined;
    };
    mapTypeControlOptions: {
        type: PropType<google.maps.MapTypeControlOptions>;
        required: false;
    };
    mapTypeId: {
        type: PropType<string>;
        required: false;
    };
    mapId: {
        type: StringConstructor;
        required: false;
    };
    maxZoom: {
        type: NumberConstructor;
        required: false;
    };
    minZoom: {
        type: NumberConstructor;
        required: false;
    };
    noClear: {
        type: BooleanConstructor;
        required: false;
        default: undefined;
    };
    panControl: {
        type: BooleanConstructor;
        required: false;
        default: undefined;
    };
    panControlPosition: {
        type: PropType<"BOTTOM_CENTER" | "BOTTOM_LEFT" | "BOTTOM_RIGHT" | "LEFT_BOTTOM" | "LEFT_CENTER" | "LEFT_TOP" | "RIGHT_BOTTOM" | "RIGHT_CENTER" | "RIGHT_TOP" | "TOP_CENTER" | "TOP_LEFT" | "TOP_RIGHT">;
        required: false;
    };
    restriction: {
        type: PropType<google.maps.MapRestriction>;
        required: false;
    };
    rotateControl: {
        type: BooleanConstructor;
        required: false;
        default: undefined;
    };
    rotateControlPosition: {
        type: PropType<"BOTTOM_CENTER" | "BOTTOM_LEFT" | "BOTTOM_RIGHT" | "LEFT_BOTTOM" | "LEFT_CENTER" | "LEFT_TOP" | "RIGHT_BOTTOM" | "RIGHT_CENTER" | "RIGHT_TOP" | "TOP_CENTER" | "TOP_LEFT" | "TOP_RIGHT">;
        required: false;
    };
    scaleControl: {
        type: BooleanConstructor;
        required: false;
        default: undefined;
    };
    scaleControlStyle: {
        type: PropType<google.maps.ScaleControlStyle>;
        required: false;
    };
    scrollwheel: {
        type: BooleanConstructor;
        required: false;
        default: undefined;
    };
    streetView: {
        type: PropType<google.maps.StreetViewPanorama>;
        required: false;
    };
    streetViewControl: {
        type: BooleanConstructor;
        required: false;
        default: undefined;
    };
    streetViewControlPosition: {
        type: PropType<"BOTTOM_CENTER" | "BOTTOM_LEFT" | "BOTTOM_RIGHT" | "LEFT_BOTTOM" | "LEFT_CENTER" | "LEFT_TOP" | "RIGHT_BOTTOM" | "RIGHT_CENTER" | "RIGHT_TOP" | "TOP_CENTER" | "TOP_LEFT" | "TOP_RIGHT">;
        required: false;
    };
    styles: {
        type: PropType<google.maps.MapTypeStyle[]>;
        required: false;
    };
    tilt: {
        type: NumberConstructor;
        required: false;
    };
    zoom: {
        type: NumberConstructor;
        required: false;
    };
    zoomControl: {
        type: BooleanConstructor;
        required: false;
        default: undefined;
    };
    zoomControlPosition: {
        type: PropType<"BOTTOM_CENTER" | "BOTTOM_LEFT" | "BOTTOM_RIGHT" | "LEFT_BOTTOM" | "LEFT_CENTER" | "LEFT_TOP" | "RIGHT_BOTTOM" | "RIGHT_CENTER" | "RIGHT_TOP" | "TOP_CENTER" | "TOP_LEFT" | "TOP_RIGHT">;
        required: false;
    };
    nonce: {
        type: StringConstructor;
        default: string;
    };
}, {
    mapRef: import("vue").Ref<HTMLElement | undefined>;
    ready: import("vue").Ref<boolean>;
    map: import("vue").Ref<google.maps.Map | undefined>;
    api: import("vue").Ref<typeof google.maps | undefined>;
    mapTilesLoaded: import("vue").Ref<boolean>;
}, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, string[], string, import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<import("vue").ExtractPropTypes<{
    apiPromise: {
        type: PropType<Promise<typeof google>>;
    };
    apiKey: {
        type: StringConstructor;
        default: string;
    };
    version: {
        type: StringConstructor;
        default: string;
    };
    libraries: {
        type: PropType<Library[]>;
        default: () => string[];
    };
    region: {
        type: StringConstructor;
        required: false;
    };
    language: {
        type: StringConstructor;
        required: false;
    };
    backgroundColor: {
        type: StringConstructor;
        required: false;
    };
    center: {
        type: PropType<google.maps.LatLng | google.maps.LatLngLiteral>;
        default: () => {
            lat: number;
            lng: number;
        };
    };
    clickableIcons: {
        type: BooleanConstructor;
        required: false;
        default: undefined;
    };
    controlSize: {
        type: NumberConstructor;
        required: false;
    };
    disableDefaultUi: {
        type: BooleanConstructor;
        required: false;
        default: undefined;
    };
    disableDoubleClickZoom: {
        type: BooleanConstructor;
        required: false;
        default: undefined;
    };
    draggable: {
        type: BooleanConstructor;
        required: false;
        default: undefined;
    };
    draggableCursor: {
        type: StringConstructor;
        required: false;
    };
    draggingCursor: {
        type: StringConstructor;
        required: false;
    };
    fullscreenControl: {
        type: BooleanConstructor;
        required: false;
        default: undefined;
    };
    fullscreenControlPosition: {
        type: PropType<"BOTTOM_CENTER" | "BOTTOM_LEFT" | "BOTTOM_RIGHT" | "LEFT_BOTTOM" | "LEFT_CENTER" | "LEFT_TOP" | "RIGHT_BOTTOM" | "RIGHT_CENTER" | "RIGHT_TOP" | "TOP_CENTER" | "TOP_LEFT" | "TOP_RIGHT">;
        required: false;
    };
    gestureHandling: {
        type: PropType<"none" | "cooperative" | "greedy" | "auto">;
        required: false;
    };
    heading: {
        type: NumberConstructor;
        required: false;
    };
    isFractionalZoomEnabled: {
        type: BooleanConstructor;
        required: false;
        default: undefined;
    };
    keyboardShortcuts: {
        type: BooleanConstructor;
        required: false;
        default: undefined;
    };
    mapTypeControl: {
        type: BooleanConstructor;
        required: false;
        default: undefined;
    };
    mapTypeControlOptions: {
        type: PropType<google.maps.MapTypeControlOptions>;
        required: false;
    };
    mapTypeId: {
        type: PropType<string>;
        required: false;
    };
    mapId: {
        type: StringConstructor;
        required: false;
    };
    maxZoom: {
        type: NumberConstructor;
        required: false;
    };
    minZoom: {
        type: NumberConstructor;
        required: false;
    };
    noClear: {
        type: BooleanConstructor;
        required: false;
        default: undefined;
    };
    panControl: {
        type: BooleanConstructor;
        required: false;
        default: undefined;
    };
    panControlPosition: {
        type: PropType<"BOTTOM_CENTER" | "BOTTOM_LEFT" | "BOTTOM_RIGHT" | "LEFT_BOTTOM" | "LEFT_CENTER" | "LEFT_TOP" | "RIGHT_BOTTOM" | "RIGHT_CENTER" | "RIGHT_TOP" | "TOP_CENTER" | "TOP_LEFT" | "TOP_RIGHT">;
        required: false;
    };
    restriction: {
        type: PropType<google.maps.MapRestriction>;
        required: false;
    };
    rotateControl: {
        type: BooleanConstructor;
        required: false;
        default: undefined;
    };
    rotateControlPosition: {
        type: PropType<"BOTTOM_CENTER" | "BOTTOM_LEFT" | "BOTTOM_RIGHT" | "LEFT_BOTTOM" | "LEFT_CENTER" | "LEFT_TOP" | "RIGHT_BOTTOM" | "RIGHT_CENTER" | "RIGHT_TOP" | "TOP_CENTER" | "TOP_LEFT" | "TOP_RIGHT">;
        required: false;
    };
    scaleControl: {
        type: BooleanConstructor;
        required: false;
        default: undefined;
    };
    scaleControlStyle: {
        type: PropType<google.maps.ScaleControlStyle>;
        required: false;
    };
    scrollwheel: {
        type: BooleanConstructor;
        required: false;
        default: undefined;
    };
    streetView: {
        type: PropType<google.maps.StreetViewPanorama>;
        required: false;
    };
    streetViewControl: {
        type: BooleanConstructor;
        required: false;
        default: undefined;
    };
    streetViewControlPosition: {
        type: PropType<"BOTTOM_CENTER" | "BOTTOM_LEFT" | "BOTTOM_RIGHT" | "LEFT_BOTTOM" | "LEFT_CENTER" | "LEFT_TOP" | "RIGHT_BOTTOM" | "RIGHT_CENTER" | "RIGHT_TOP" | "TOP_CENTER" | "TOP_LEFT" | "TOP_RIGHT">;
        required: false;
    };
    styles: {
        type: PropType<google.maps.MapTypeStyle[]>;
        required: false;
    };
    tilt: {
        type: NumberConstructor;
        required: false;
    };
    zoom: {
        type: NumberConstructor;
        required: false;
    };
    zoomControl: {
        type: BooleanConstructor;
        required: false;
        default: undefined;
    };
    zoomControlPosition: {
        type: PropType<"BOTTOM_CENTER" | "BOTTOM_LEFT" | "BOTTOM_RIGHT" | "LEFT_BOTTOM" | "LEFT_CENTER" | "LEFT_TOP" | "RIGHT_BOTTOM" | "RIGHT_CENTER" | "RIGHT_TOP" | "TOP_CENTER" | "TOP_LEFT" | "TOP_RIGHT">;
        required: false;
    };
    nonce: {
        type: StringConstructor;
        default: string;
    };
}>> & {
    [x: `on${Capitalize<string>}`]: ((...args: any[]) => any) | undefined;
}, {
    draggable: boolean;
    version: string;
    center: google.maps.LatLng | google.maps.LatLngLiteral;
    apiKey: string;
    libraries: Library[];
    clickableIcons: boolean;
    disableDefaultUi: boolean;
    disableDoubleClickZoom: boolean;
    fullscreenControl: boolean;
    isFractionalZoomEnabled: boolean;
    keyboardShortcuts: boolean;
    mapTypeControl: boolean;
    noClear: boolean;
    panControl: boolean;
    rotateControl: boolean;
    scaleControl: boolean;
    scrollwheel: boolean;
    streetViewControl: boolean;
    zoomControl: boolean;
    nonce: string;
}, {}>;
export default _default;
