export var RequestType;
(function (RequestType) {
    RequestType[RequestType["SEARCH"] = 0] = "SEARCH";
    RequestType[RequestType["REVERSE"] = 1] = "REVERSE";
})(RequestType || (RequestType = {}));
export default class AbstractProvider {
    options;
    constructor(options = {}) {
        this.options = options;
    }
    getParamString(params = {}) {
        const set = { ...this.options.params, ...params };
        return Object.keys(set)
            .map((key) => `${encodeURIComponent(key)}=${encodeURIComponent(set[key])}`)
            .join('&');
    }
    getUrl(url, params) {
        return `${url}?${this.getParamString(params)}`;
    }
    async search(options) {
        const url = this.endpoint({
            query: options.query,
            type: RequestType.SEARCH,
        });
        const request = await fetch(url);
        const json = await request.json();
        return this.parse({ data: json });
    }
}
//# sourceMappingURL=provider.js.map