import AbstractProvider from './provider';
export default class OpenCageProvider extends AbstractProvider {
    searchUrl = 'https://api.opencagedata.com/geocode/v1/json';
    endpoint({ query }) {
        const params = typeof query === 'string' ? { q: query } : query;
        params.format = 'json';
        return this.getUrl(this.searchUrl, params);
    }
    parse(response) {
        return response.data.results.map((r) => {
            let bounds = null;
            if (r.bounds) {
                bounds = [
                    [r.bounds.southwest.lat, r.bounds.southwest.lng],
                    [r.bounds.northeast.lat, r.bounds.northeast.lng], // n, e
                ];
            }
            return {
                x: r.geometry.lng,
                y: r.geometry.lat,
                label: r.formatted,
                bounds,
                raw: r,
            };
        });
    }
    async search(options) {
        // opencage returns a 400 error when query length < 2
        if (options.query.length < 2) {
            return [];
        }
        return super.search(options);
    }
}
//# sourceMappingURL=openCageProvider.js.map