import AbstractProvider from './provider';
import { Loader } from '@googlemaps/js-api-loader';
export default class GoogleProvider extends AbstractProvider {
    loader = null;
    geocoder = null;
    constructor(options) {
        super(options);
        if (typeof window !== 'undefined') {
            this.loader = new Loader(options).load().then((google) => {
                const geocoder = new google.maps.Geocoder();
                this.geocoder = geocoder;
                return geocoder;
            });
        }
    }
    endpoint({ query }) {
        throw new Error('Method not implemented.');
    }
    parse(response) {
        return response.data.results.map((r) => {
            const { lat, lng } = r.geometry.location.toJSON();
            const { east, north, south, west } = r.geometry.viewport.toJSON();
            return {
                x: lng,
                y: lat,
                label: r.formatted_address,
                bounds: [
                    [south, west],
                    [north, east],
                ],
                raw: r,
            };
        });
    }
    async search(options) {
        const geocoder = this.geocoder || (await this.loader);
        if (!geocoder) {
            throw new Error('GoogleMaps GeoCoder is not loaded. Are you trying to run this server side?');
        }
        const response = await geocoder
            .geocode({ address: options.query }, (response) => ({
            results: response,
        }))
            .catch((e) => {
            if (e.code !== 'ZERO_RESULTS') {
                console.error(`${e.code}: ${e.message}`);
            }
            return { results: [] };
        });
        return this.parse({ data: response });
    }
}
//# sourceMappingURL=googleProvider.js.map