import AbstractProvider from './provider';
import { createScriptElement } from '../domUtils';
export default class BingProvider extends AbstractProvider {
    searchUrl = 'https://dev.virtualearth.net/REST/v1/Locations';
    endpoint({ query, jsonp }) {
        const params = typeof query === 'string' ? { q: query } : query;
        params.jsonp = jsonp;
        return this.getUrl(this.searchUrl, params);
    }
    parse(response) {
        if (response.data.resourceSets.length === 0) {
            return [];
        }
        return response.data.resourceSets[0].resources.map((r) => ({
            x: r.point.coordinates[1],
            y: r.point.coordinates[0],
            label: r.address.formattedAddress,
            bounds: [
                [r.bbox[0], r.bbox[1]],
                [r.bbox[2], r.bbox[3]], // n, e
            ],
            raw: r,
        }));
    }
    async search({ query }) {
        const jsonp = `BING_JSONP_CB_${Date.now()}`;
        const json = await createScriptElement(this.endpoint({ query, jsonp }), jsonp);
        return this.parse({ data: json });
    }
}
//# sourceMappingURL=bingProvider.js.map