import AbstractProvider from './provider';
export default class AMapProvider extends AbstractProvider {
    searchUrl = 'https://restapi.amap.com/v3/geocode/geo';
    endpoint({ query }) {
        const params = typeof query === 'string' ? { address: query } : query;
        params.output = 'JSON';
        return this.getUrl(this.searchUrl, params);
    }
    parse(response) {
        const records = response.data.geocodes ?? [];
        return records.map((r) => ({
            x: Number(r.location.substring(0, r.location.indexOf(','))),
            y: Number(r.location.substring(r.location.indexOf(',') + 1)),
            label: r.formatted_address,
            bounds: null,
            raw: r,
        }));
    }
}
//# sourceMappingURL=amapProvider.js.map