import AbstractProvider, { EndpointArgument, ParseArgument, SearchResult } from './provider';
export declare type RequestResult = {
    status: number;
    count: number;
    info: string;
    geocodes: RawResult[];
};
export interface RawResult {
    formatted_address: string;
    country: string;
    province: string;
    city: string;
    citycode: string;
    district: string;
    number: string;
    adcode: string;
    location: string;
    level: string;
}
export default class AMapProvider extends AbstractProvider<RequestResult, RawResult> {
    searchUrl: string;
    endpoint({ query }: EndpointArgument): string;
    parse(response: ParseArgument<RequestResult>): SearchResult<RawResult>[];
}
