import { createVNode, mergeProps } from "vue";
export default {
  name: 'ZapOffIcon',
  props: {
    size: {
      type: String,
      default: '16',
      validator: s => !isNaN(s) || s.length >= 2 && !isNaN(s.slice(0, s.length - 1)) && s.slice(-1) === 'x'
    }
  },

  setup(props, ctx) {
    const size = props.size.slice(-1) === 'x' ? props.size.slice(0, props.size.length - 1) + 'em' : parseInt(props.size) + 'px';
    const attrs = { ...ctx.attrs
    };
    attrs.width = attrs.width || size;
    attrs.height = attrs.height || size;
    return () => createVNode("svg", mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "fill": "none",
      "stroke": "currentColor",
      "stroke-width": "2",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "class": "feather feather-zap-off"
    }, { ...attrs
    }), [createVNode("polyline", {
      "points": "12.41 6.75 13 2 10.57 4.92"
    }), createVNode("polyline", {
      "points": "18.57 12.91 21 10 15.66 10"
    }), createVNode("polyline", {
      "points": "8 8 3 14 12 14 11 22 16 16"
    }), createVNode("line", {
      "x1": "1",
      "y1": "1",
      "x2": "23",
      "y2": "23"
    })]);
  }

};