import { createVNode, mergeProps } from "vue";
export default {
  name: 'UserPlusIcon',
  props: {
    size: {
      type: String,
      default: '16',
      validator: s => !isNaN(s) || s.length >= 2 && !isNaN(s.slice(0, s.length - 1)) && s.slice(-1) === 'x'
    }
  },

  setup(props, ctx) {
    const size = props.size.slice(-1) === 'x' ? props.size.slice(0, props.size.length - 1) + 'em' : parseInt(props.size) + 'px';
    const attrs = { ...ctx.attrs
    };
    attrs.width = attrs.width || size;
    attrs.height = attrs.height || size;
    return () => createVNode("svg", mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "fill": "none",
      "stroke": "currentColor",
      "stroke-width": "2",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "class": "feather feather-user-plus"
    }, { ...attrs
    }), [createVNode("path", {
      "d": "M16 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"
    }), createVNode("circle", {
      "cx": "8.5",
      "cy": "7",
      "r": "4"
    }), createVNode("line", {
      "x1": "20",
      "y1": "8",
      "x2": "20",
      "y2": "14"
    }), createVNode("line", {
      "x1": "23",
      "y1": "11",
      "x2": "17",
      "y2": "11"
    })]);
  }

};