import { createVNode, mergeProps } from "vue";
export default {
  name: 'SunsetIcon',
  props: {
    size: {
      type: String,
      default: '16',
      validator: s => !isNaN(s) || s.length >= 2 && !isNaN(s.slice(0, s.length - 1)) && s.slice(-1) === 'x'
    }
  },

  setup(props, ctx) {
    const size = props.size.slice(-1) === 'x' ? props.size.slice(0, props.size.length - 1) + 'em' : parseInt(props.size) + 'px';
    const attrs = { ...ctx.attrs
    };
    attrs.width = attrs.width || size;
    attrs.height = attrs.height || size;
    return () => createVNode("svg", mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "fill": "none",
      "stroke": "currentColor",
      "stroke-width": "2",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "class": "feather feather-sunset"
    }, { ...attrs
    }), [createVNode("path", {
      "d": "M17 18a5 5 0 0 0-10 0"
    }), createVNode("line", {
      "x1": "12",
      "y1": "9",
      "x2": "12",
      "y2": "2"
    }), createVNode("line", {
      "x1": "4.22",
      "y1": "10.22",
      "x2": "5.64",
      "y2": "11.64"
    }), createVNode("line", {
      "x1": "1",
      "y1": "18",
      "x2": "3",
      "y2": "18"
    }), createVNode("line", {
      "x1": "21",
      "y1": "18",
      "x2": "23",
      "y2": "18"
    }), createVNode("line", {
      "x1": "18.36",
      "y1": "11.64",
      "x2": "19.78",
      "y2": "10.22"
    }), createVNode("line", {
      "x1": "23",
      "y1": "22",
      "x2": "1",
      "y2": "22"
    }), createVNode("polyline", {
      "points": "16 5 12 9 8 5"
    })]);
  }

};