import { createVNode, mergeProps } from "vue";
export default {
  name: 'SlidersIcon',
  props: {
    size: {
      type: String,
      default: '16',
      validator: s => !isNaN(s) || s.length >= 2 && !isNaN(s.slice(0, s.length - 1)) && s.slice(-1) === 'x'
    }
  },

  setup(props, ctx) {
    const size = props.size.slice(-1) === 'x' ? props.size.slice(0, props.size.length - 1) + 'em' : parseInt(props.size) + 'px';
    const attrs = { ...ctx.attrs
    };
    attrs.width = attrs.width || size;
    attrs.height = attrs.height || size;
    return () => createVNode("svg", mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "fill": "none",
      "stroke": "currentColor",
      "stroke-width": "2",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "class": "feather feather-sliders"
    }, { ...attrs
    }), [createVNode("line", {
      "x1": "4",
      "y1": "21",
      "x2": "4",
      "y2": "14"
    }), createVNode("line", {
      "x1": "4",
      "y1": "10",
      "x2": "4",
      "y2": "3"
    }), createVNode("line", {
      "x1": "12",
      "y1": "21",
      "x2": "12",
      "y2": "12"
    }), createVNode("line", {
      "x1": "12",
      "y1": "8",
      "x2": "12",
      "y2": "3"
    }), createVNode("line", {
      "x1": "20",
      "y1": "21",
      "x2": "20",
      "y2": "16"
    }), createVNode("line", {
      "x1": "20",
      "y1": "12",
      "x2": "20",
      "y2": "3"
    }), createVNode("line", {
      "x1": "1",
      "y1": "14",
      "x2": "7",
      "y2": "14"
    }), createVNode("line", {
      "x1": "9",
      "y1": "8",
      "x2": "15",
      "y2": "8"
    }), createVNode("line", {
      "x1": "17",
      "y1": "16",
      "x2": "23",
      "y2": "16"
    })]);
  }

};