import { createVNode, mergeProps } from "vue";
export default {
  name: 'Share2Icon',
  props: {
    size: {
      type: String,
      default: '16',
      validator: s => !isNaN(s) || s.length >= 2 && !isNaN(s.slice(0, s.length - 1)) && s.slice(-1) === 'x'
    }
  },

  setup(props, ctx) {
    const size = props.size.slice(-1) === 'x' ? props.size.slice(0, props.size.length - 1) + 'em' : parseInt(props.size) + 'px';
    const attrs = { ...ctx.attrs
    };
    attrs.width = attrs.width || size;
    attrs.height = attrs.height || size;
    return () => createVNode("svg", mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "fill": "none",
      "stroke": "currentColor",
      "stroke-width": "2",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "class": "feather feather-share-2"
    }, { ...attrs
    }), [createVNode("circle", {
      "cx": "18",
      "cy": "5",
      "r": "3"
    }), createVNode("circle", {
      "cx": "6",
      "cy": "12",
      "r": "3"
    }), createVNode("circle", {
      "cx": "18",
      "cy": "19",
      "r": "3"
    }), createVNode("line", {
      "x1": "8.59",
      "y1": "13.51",
      "x2": "15.42",
      "y2": "17.49"
    }), createVNode("line", {
      "x1": "15.41",
      "y1": "6.51",
      "x2": "8.59",
      "y2": "10.49"
    })]);
  }

};