import { createVNode, mergeProps } from "vue";
export default {
  name: 'RepeatIcon',
  props: {
    size: {
      type: String,
      default: '16',
      validator: s => !isNaN(s) || s.length >= 2 && !isNaN(s.slice(0, s.length - 1)) && s.slice(-1) === 'x'
    }
  },

  setup(props, ctx) {
    const size = props.size.slice(-1) === 'x' ? props.size.slice(0, props.size.length - 1) + 'em' : parseInt(props.size) + 'px';
    const attrs = { ...ctx.attrs
    };
    attrs.width = attrs.width || size;
    attrs.height = attrs.height || size;
    return () => createVNode("svg", mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "fill": "none",
      "stroke": "currentColor",
      "stroke-width": "2",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "class": "feather feather-repeat"
    }, { ...attrs
    }), [createVNode("polyline", {
      "points": "17 1 21 5 17 9"
    }), createVNode("path", {
      "d": "M3 11V9a4 4 0 0 1 4-4h14"
    }), createVNode("polyline", {
      "points": "7 23 3 19 7 15"
    }), createVNode("path", {
      "d": "M21 13v2a4 4 0 0 1-4 4H3"
    })]);
  }

};