import { createVNode, mergeProps } from "vue";
export default {
  name: 'HardDriveIcon',
  props: {
    size: {
      type: String,
      default: '16',
      validator: s => !isNaN(s) || s.length >= 2 && !isNaN(s.slice(0, s.length - 1)) && s.slice(-1) === 'x'
    }
  },

  setup(props, ctx) {
    const size = props.size.slice(-1) === 'x' ? props.size.slice(0, props.size.length - 1) + 'em' : parseInt(props.size) + 'px';
    const attrs = { ...ctx.attrs
    };
    attrs.width = attrs.width || size;
    attrs.height = attrs.height || size;
    return () => createVNode("svg", mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "fill": "none",
      "stroke": "currentColor",
      "stroke-width": "2",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "class": "feather feather-hard-drive"
    }, { ...attrs
    }), [createVNode("line", {
      "x1": "22",
      "y1": "12",
      "x2": "2",
      "y2": "12"
    }), createVNode("path", {
      "d": "M5.45 5.11L2 12v6a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2v-6l-3.45-6.89A2 2 0 0 0 16.76 4H7.24a2 2 0 0 0-1.79 1.11z"
    }), createVNode("line", {
      "x1": "6",
      "y1": "16",
      "x2": "6.01",
      "y2": "16"
    }), createVNode("line", {
      "x1": "10",
      "y1": "16",
      "x2": "10.01",
      "y2": "16"
    })]);
  }

};