import { createVNode, mergeProps } from "vue";
export default {
  name: 'CoffeeIcon',
  props: {
    size: {
      type: String,
      default: '16',
      validator: s => !isNaN(s) || s.length >= 2 && !isNaN(s.slice(0, s.length - 1)) && s.slice(-1) === 'x'
    }
  },

  setup(props, ctx) {
    const size = props.size.slice(-1) === 'x' ? props.size.slice(0, props.size.length - 1) + 'em' : parseInt(props.size) + 'px';
    const attrs = { ...ctx.attrs
    };
    attrs.width = attrs.width || size;
    attrs.height = attrs.height || size;
    return () => createVNode("svg", mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "fill": "none",
      "stroke": "currentColor",
      "stroke-width": "2",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "class": "feather feather-coffee"
    }, { ...attrs
    }), [createVNode("path", {
      "d": "M18 8h1a4 4 0 0 1 0 8h-1"
    }), createVNode("path", {
      "d": "M2 8h16v9a4 4 0 0 1-4 4H6a4 4 0 0 1-4-4V8z"
    }), createVNode("line", {
      "x1": "6",
      "y1": "1",
      "x2": "6",
      "y2": "4"
    }), createVNode("line", {
      "x1": "10",
      "y1": "1",
      "x2": "10",
      "y2": "4"
    }), createVNode("line", {
      "x1": "14",
      "y1": "1",
      "x2": "14",
      "y2": "4"
    })]);
  }

};