import { createVNode, mergeProps } from "vue";
export default {
  name: 'CodesandboxIcon',
  props: {
    size: {
      type: String,
      default: '16',
      validator: s => !isNaN(s) || s.length >= 2 && !isNaN(s.slice(0, s.length - 1)) && s.slice(-1) === 'x'
    }
  },

  setup(props, ctx) {
    const size = props.size.slice(-1) === 'x' ? props.size.slice(0, props.size.length - 1) + 'em' : parseInt(props.size) + 'px';
    const attrs = { ...ctx.attrs
    };
    attrs.width = attrs.width || size;
    attrs.height = attrs.height || size;
    return () => createVNode("svg", mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "fill": "none",
      "stroke": "currentColor",
      "stroke-width": "2",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "class": "feather feather-codesandbox"
    }, { ...attrs
    }), [createVNode("path", {
      "d": "M21 16V8a2 2 0 0 0-1-1.73l-7-4a2 2 0 0 0-2 0l-7 4A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16z"
    }), createVNode("polyline", {
      "points": "7.5 4.21 12 6.81 16.5 4.21"
    }), createVNode("polyline", {
      "points": "7.5 19.79 7.5 14.6 3 12"
    }), createVNode("polyline", {
      "points": "21 12 16.5 14.6 16.5 19.79"
    }), createVNode("polyline", {
      "points": "3.27 6.96 12 12.01 20.73 6.96"
    }), createVNode("line", {
      "x1": "12",
      "y1": "22.08",
      "x2": "12",
      "y2": "12"
    })]);
  }

};