import { createVNode, mergeProps } from "vue";
export default {
  name: 'ChromeIcon',
  props: {
    size: {
      type: String,
      default: '16',
      validator: s => !isNaN(s) || s.length >= 2 && !isNaN(s.slice(0, s.length - 1)) && s.slice(-1) === 'x'
    }
  },

  setup(props, ctx) {
    const size = props.size.slice(-1) === 'x' ? props.size.slice(0, props.size.length - 1) + 'em' : parseInt(props.size) + 'px';
    const attrs = { ...ctx.attrs
    };
    attrs.width = attrs.width || size;
    attrs.height = attrs.height || size;
    return () => createVNode("svg", mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "fill": "none",
      "stroke": "currentColor",
      "stroke-width": "2",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "class": "feather feather-chrome"
    }, { ...attrs
    }), [createVNode("circle", {
      "cx": "12",
      "cy": "12",
      "r": "10"
    }), createVNode("circle", {
      "cx": "12",
      "cy": "12",
      "r": "4"
    }), createVNode("line", {
      "x1": "21.17",
      "y1": "8",
      "x2": "12",
      "y2": "8"
    }), createVNode("line", {
      "x1": "3.95",
      "y1": "6.06",
      "x2": "8.54",
      "y2": "14"
    }), createVNode("line", {
      "x1": "10.88",
      "y1": "21.94",
      "x2": "15.46",
      "y2": "14"
    })]);
  }

};