# Installation
> `npm install --save @types/svg-arc-to-cubic-bezier`

# Summary
This package contains type definitions for svg-arc-to-cubic-bezier (https://github.com/colinmeinke/svg-arc-to-cubic-bezier#readme).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/svg-arc-to-cubic-bezier.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/svg-arc-to-cubic-bezier/index.d.ts)
````ts
declare namespace arcToBezier {
    interface Arc {
        px: number;

        py: number;

        cx: number;

        cy: number;

        rx: number;

        ry: number;

        /** @default 0 */
        xAxisRotation: number;

        /** @default 0 */
        largeArcFlag: 0 | 1;

        /** @default 0 */
        sweepFlag: 0 | 1;
    }

    interface CubicBezierCurve {
        x1: number;
        y1: number;
        x2: number;
        y2: number;
        x: number;
        y: number;
    }
}

declare function arcToBezier(x: arcToBezier.Arc): arcToBezier.CubicBezierCurve[];

export = arcToBezier;

````

### Additional Details
 * Last updated: Fri, 27 Sep 2024 16:40:34 GMT
 * Dependencies: none

# Credits
These definitions were written by [Fabien Caylus](https://github.com/fcaylus).
