/**
 * @license Copyright (c) 2003-2023, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * @module ckbox/ckboximageedit/ckboximageeditui
 */
import { Plugin } from 'ckeditor5/src/core';
import { ButtonView } from 'ckeditor5/src/ui';
import ckboxImageEditIcon from '../../theme/icons/ckbox-image-edit.svg';
/**
 * The UI plugin of the CKBox image edit feature.
 *
 * It registers the `'ckboxImageEdit'` UI button in the editor's {@link module:ui/componentfactory~ComponentFactory component factory}
 * that allows you to open the CKBox dialog and edit the image.
 */
export default class CKBoxImageEditUI extends Plugin {
    /**
     * @inheritDoc
     */
    static get pluginName() {
        return 'CKBoxImageEditUI';
    }
    /**
     * @inheritDoc
     */
    init() {
        const editor = this.editor;
        editor.ui.componentFactory.add('ckboxImageEdit', locale => {
            const command = editor.commands.get('ckboxImageEdit');
            const view = new ButtonView(locale);
            const t = locale.t;
            view.set({
                label: t('Edit image'),
                icon: ckboxImageEditIcon,
                tooltip: true
            });
            view.bind('isOn').to(command, 'value', command, 'isEnabled', (value, isEnabled) => value && isEnabled);
            view.bind('isEnabled').to(command);
            // Execute the command.
            this.listenTo(view, 'execute', () => {
                editor.execute('ckboxImageEdit');
                editor.editing.view.focus();
            });
            return view;
        });
    }
}
