import { ColorPickerDefaultTheme } from "./ColorPickerDefaultTheme";
import { Color, color } from "../../core/util/Color";
import { Container } from "../../core/render/Container";
import { Graphics } from "../../core/render/Graphics";
import { RoundedRectangle } from "../../core/render/RoundedRectangle";
export class ColorPickerButton extends Container {
    constructor() {
        super(...arguments);
        Object.defineProperty(this, "_currentRectangle", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "noColorGraphics", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: this.children.push(Graphics.new(this._root, {
                themeTags: ["nocolor"]
            }))
        });
        Object.defineProperty(this, "icon", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: this.children.push(Graphics.new(this._root, {
                themeTags: ["icon"]
            }))
        });
    }
    _afterNew() {
        this._defaultThemes.push(ColorPickerDefaultTheme.new(this._root));
        this.addTag("colorpickerbutton");
        super._afterNew();
        this.set("background", RoundedRectangle.new(this._root, {
            themeTags: ["background"]
        }));
    }
    _changed() {
        super._changed();
        if (this.isDirty("color") || this.isPrivateDirty("color") || this.isDirty("colorOpacity") || this.isDirty("backgroundColor")) {
            let fill = this.get("color", this.getPrivate("color"));
            let opacity = this.get("colorOpacity", 1);
            if (!fill) {
                this.noColorGraphics.show();
            }
            else {
                this.noColorGraphics.hide();
            }
            const backgroundColor = this.get("backgroundColor", color(0xffffff));
            if (!fill) {
                fill = backgroundColor;
            }
            let stroke = fill;
            let d = -.1;
            if (backgroundColor.toHSL().l < 0.5) {
                d = -d;
            }
            stroke = Color.lighten(fill, d);
            this.noColorGraphics.set("stroke", stroke);
            const bg = this.get("background");
            if (bg) {
                bg.setAll({
                    fill: fill,
                    stroke: stroke,
                    fillOpacity: opacity,
                    strokeOpacity: Math.max(0.2, opacity)
                });
            }
            this.icon.set("stroke", Color.alternative(stroke, this._root.interfaceColors.get("alternativeText"), this._root.interfaceColors.get("text")));
        }
    }
}
Object.defineProperty(ColorPickerButton, "className", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: "ColorPickerButton"
});
Object.defineProperty(ColorPickerButton, "classNames", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: Container.classNames.concat([ColorPickerButton.className])
});
//# sourceMappingURL=ColorPickerButton.js.map