import { Color } from "../../core/util/Color";
import { Container, IContainerEvents, IContainerPrivate, IContainerSettings } from "../../core/render/Container";
import { Graphics } from "../../core/render/Graphics";
import { RoundedRectangle } from "../../core/render/RoundedRectangle";
export interface IColorPickerButtonSettings extends IContainerSettings {
    color?: Color;
    backgroundColor?: Color;
    colorOpacity?: number;
    disableOpacity?: boolean;
}
export interface IColorPickerButtonPrivate extends IContainerPrivate {
    color?: Color;
}
export interface IColorPickerButtonEvents extends IContainerEvents {
}
export declare class ColorPickerButton extends Container {
    static className: string;
    static classNames: Array<string>;
    _settings: IColorPickerButtonSettings;
    _privateSettings: IColorPickerButtonPrivate;
    _events: IColorPickerButtonEvents;
    protected _currentRectangle: RoundedRectangle | undefined;
    noColorGraphics: Graphics;
    icon: Graphics;
    protected _afterNew(): void;
    _changed(): void;
}
//# sourceMappingURL=ColorPickerButton.d.ts.map