import type { ColorPickerButton } from "./ColorPickerButton";
import type { ISpritePointerEvent } from "../../core/render/Sprite";
import { Color } from "../../core/util/Color";
import { ListTemplate } from "../../core/util/List";
import { Button } from "../../core/render/Button";
import { Circle } from "../../core/render/Circle";
import { Container, IContainerEvents, IContainerPrivate, IContainerSettings } from "../../core/render/Container";
import { EditableLabel } from "../../core/render/EditableLabel";
import { Rectangle } from "../../core/render/Rectangle";
import { RoundedRectangle } from "../../core/render/RoundedRectangle";
import { Slider } from "../../core/render/Slider";
export interface IColorPickerSettings extends IContainerSettings {
    /**
     * Color picker button to use.
     */
    colorButton?: ColorPickerButton;
    hue?: number;
    /**
     * Color of the color picker.
     */
    color?: Color;
    /**
     * Opacity of the color.
     */
    colorOpacity?: number;
    /**
     * Background color of the color picker.
     */
    backgroundColor?: Color;
}
export interface IColorPickerPrivate extends IContainerPrivate {
}
export interface IColorPickerEvents extends IContainerEvents {
    colorchanged: {
        color?: Color;
        colorOpacity?: number;
    };
}
export declare class ColorPicker extends Container {
    static className: string;
    static classNames: Array<string>;
    _settings: IColorPickerSettings;
    _privateSettings: IColorPickerPrivate;
    _events: IColorPickerEvents;
    protected _currentRectangle: RoundedRectangle | undefined;
    _clickOverlay: Rectangle;
    readonly rectangles: ListTemplate<RoundedRectangle>;
    /**
     * Container for color gradients.
     */
    gradientsContainer: Container;
    /**
     * Container for color gradients.
     * @ignore
     */
    colorGradientsContainer: Container;
    /**
     * Rectangle that displays the color gradient.
     * @ignore
     */
    colorRectangle: Rectangle;
    /**
     * Rectangle that displays the white overlay.
     * @ignore*
     */
    colorRectangleWhiteOverlay: Rectangle;
    /**
     * Rectangle that displays the black overlay.
     * @ignore
     */
    colorRectangleBlackOverlay: Rectangle;
    /**
     * Slider that displays the hue of the color.
     */
    slider: Slider;
    /**
     * @ignore
     */
    inputContainer: Container;
    /**
     * Button that shows color picker button.
     */
    pickerButton: Button;
    /**
     * Button that allows to remove color.
     */
    noColorButton: Button;
    /**
     * Editable label that allows to input color in hex format.
     */
    colorInput: EditableLabel;
    /**
     * @ignore
     */
    opacityContainer: Container;
    /**
     * Slider that allows to change opacity of the color.
     */
    opacitySlider: Slider;
    /**
     * Circle that indicates the target color.
     */
    targetCircle: Circle;
    /**
     * @ignore
     */
    buttonsContainer: Container;
    /**
     * Button that allows to cancel color selection.
     */
    cancelButton: Button;
    /**
     * Button that allows to confirm color selection.
     */
    okButton: Button;
    protected _isColorDown: boolean;
    protected _isPicking: boolean;
    protected _isEditing: boolean;
    protected _previousColor: Color | undefined;
    protected _previousOpacity: number | undefined;
    protected _prevColor: Color | undefined;
    /**
     * @ignore
     */
    protected _afterNew(): void;
    /**
     * @ignore
     */
    _updateChildren(): void;
    /**
     * @ignore
     */
    protected _handleDirtyHue(): void;
    /**
     * @ignore
     */
    protected _handleTargetMove(e: ISpritePointerEvent): void;
    /**
     * @ignore
     */
    protected _updateColor(): void;
    /**
     * @ignore
     */
    protected _updateOpacitySliderGrip(): void;
    /**
     * Cancels color selection and restores previous color.
     */
    cancel(): void;
}
//# sourceMappingURL=ColorPicker.d.ts.map