import { Graphics } from "./Graphics";
/**
 * Draws a rectangle.
 *
 * @see {@link https://www.amcharts.com/docs/v5/concepts/common-elements/graphics/} for more info
 * @important
 */
export class Rectangle extends Graphics {
    _afterNew() {
        super._afterNew();
        this._display.isMeasured = true;
        this.setPrivateRaw("trustBounds", true);
    }
    _beforeChanged() {
        super._beforeChanged();
        if (this.isDirty("width") || this.isDirty("height") || this.isPrivateDirty("width") || this.isPrivateDirty("height")) {
            this._clear = true;
        }
    }
    _changed() {
        super._changed();
        if (this._clear && !this.get("draw")) {
            this._draw();
        }
    }
    _draw() {
        let w = this.width();
        let h = this.height();
        let x = 0;
        let y = 0;
        let wSign = w / Math.abs(w);
        let hSign = h / Math.abs(h);
        if (this.get("containStroke", false)) {
            const strokeWidth = this.get("strokeWidth", 0);
            w -= strokeWidth * wSign;
            h -= strokeWidth * hSign;
            x += strokeWidth / 2 * wSign;
            y += strokeWidth / 2 * hSign;
        }
        this._display.drawRect(x, y, w, h);
    }
    _updateSize() {
        this.markDirty();
        this._clear = true;
    }
}
Object.defineProperty(Rectangle, "className", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: "Rectangle"
});
Object.defineProperty(Rectangle, "classNames", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: Graphics.classNames.concat([Rectangle.className])
});
//# sourceMappingURL=Rectangle.js.map