import { Label } from "../../core/render/Label";
import { Container } from "../../core/render/Container";
import { Slice } from "../../core/render/Slice";
import { p100, percent } from "../../core/util/Percent";
import { Circle } from "./Circle";
import * as $utils from "../../core/util/Utils";
/**
 * Draws an interactive progress pie.
 *
 * @important
 * @since 5.14.0
 */
export class ProgressPie extends Container {
    constructor() {
        super(...arguments);
        Object.defineProperty(this, "circle", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: this.children.push(Circle.new(this._root, {
                themeTags: ["background"]
            }))
        });
        Object.defineProperty(this, "label", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: this.children.push(Label.new(this._root, {}))
        });
        Object.defineProperty(this, "slice", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: this.children.push(Slice.new(this._root, { isMeasured: false }))
        });
        Object.defineProperty(this, "backgroundSlice", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: this.children.push(Slice.new(this._root, { themeTags: ["background"] }))
        });
    }
    _afterNew() {
        this.addTag("progresspie");
        super._afterNew();
    }
    _updateChildren() {
        super._updateChildren();
        if (this.isDirty("width") || this.isDirty("height") || this.isDirty("radius") || this.isDirty("innerRadius")) {
            const width = this.innerWidth();
            const height = this.innerHeight();
            const radius = $utils.relativeToValue(this.get("radius", p100), Math.min(width, height) / 2);
            const innerRadius = $utils.relativeToValue(this.get("innerRadius", percent(80)), radius);
            this.slice.setAll({
                radius: radius,
                innerRadius: innerRadius,
            });
            this.backgroundSlice.setAll({
                radius: radius,
                innerRadius: innerRadius,
            });
            this.circle.set("radius", radius);
        }
        if (this.isDirty("value")) {
            const value = this.get("value", 0);
            this.slice.set("arc", value * 360);
            this.backgroundSlice.set("arc", 360);
            this.label.setAll({
                text: this.getNumberFormatter().format(value * 100, this.get("numberFormat", "#'"))
            });
            this.root.events.once("frameended", () => {
                this.label.markDirtyKey("text");
            });
        }
    }
}
Object.defineProperty(ProgressPie, "className", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: "ProgressPie"
});
Object.defineProperty(ProgressPie, "classNames", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: Container.classNames.concat([ProgressPie.className])
});
//# sourceMappingURL=ProgressPie.js.map