import { Label } from "../../core/render/Label";
import { Container, IContainerPrivate, IContainerSettings } from "../../core/render/Container";
import { Slice } from "../../core/render/Slice";
import { Percent } from "../../core/util/Percent";
import { Circle } from "./Circle";
export interface IProgressPieSettings extends IContainerSettings {
    value?: number;
    radius?: number | Percent;
    innerRadius?: number | Percent;
    numberFormat?: string;
}
export interface IProgressPiePrivate extends IContainerPrivate {
}
/**
 * Draws an interactive progress pie.
 *
 * @important
 * @since 5.14.0
 */
export declare class ProgressPie extends Container {
    circle: Circle;
    label: Label;
    slice: Slice;
    backgroundSlice: Slice;
    protected _afterNew(): void;
    _settings: IProgressPieSettings;
    _privateSettings: IProgressPiePrivate;
    static className: string;
    static classNames: Array<string>;
    _updateChildren(): void;
}
//# sourceMappingURL=ProgressPie.d.ts.map