import { Graphics, IGraphicsSettings, IGraphicsPrivate } from "./Graphics";
import type { IPoint } from "../util/IPoint";
export interface IOrthogonalLineSettings extends IGraphicsSettings {
    /**
     * A list of [[IPoint]] (x/y coordinates) points for the Orthogonal Line.
     */
    points?: Array<IPoint>;
    /**
     * Corner radius between segments.
     */
    cornerRadius?: number;
}
export interface IOrthogonalLinePrivate extends IGraphicsPrivate {
}
/**
 * Draws an Orthogonal line.
 *
 * @important
 * @since 5.14.0
 */
export declare class OrthogonalLine extends Graphics {
    _settings: IOrthogonalLineSettings;
    _privateSettings: IOrthogonalLinePrivate;
    static className: string;
    static classNames: Array<string>;
    _beforeChanged(): void;
    static makeOrthogonal(points: Array<IPoint>): Array<IPoint>;
    /**
     * Handles changes and redraws the orthogonal line with optional rounded corners.
     */
    _changed(): void;
}
//# sourceMappingURL=OrthogonalLine.d.ts.map