import { Container, IContainerPrivate, IContainerSettings } from "../../core/render/Container";
import { EditableLabel } from "../../core/render/EditableLabel";
import { Triangle } from "../../core/render/Triangle";
export interface INumericStepperSettings extends IContainerSettings {
    value?: number;
}
export interface INumericStepperPrivate extends IContainerPrivate {
}
/**
 * Draws an interactive NumericStepper.
 *
 * @important
 * @since 5.14.0
 */
export declare class NumericStepper extends Container {
    label: EditableLabel;
    buttonsContainer: Container;
    upButton: Triangle;
    downButton: Triangle;
    _settings: INumericStepperSettings;
    _privateSettings: INumericStepperPrivate;
    static className: string;
    static classNames: Array<string>;
    protected _afterNew(): void;
    _updateChildren(): void;
}
//# sourceMappingURL=NumericStepper.d.ts.map