import { Container } from "./Container";
import { Triangle } from "./Triangle";
import { OrthogonalLine } from "./OrthogonalLine";
import * as $math from "../util/Math";
/**
 *
 * @see {@link https://www.amcharts.com/docs/v5/concepts/common-elements/graphics/} for more info
 * @important
 */
export class Link extends Container {
    constructor() {
        super(...arguments);
        Object.defineProperty(this, "line", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: this.children.push(OrthogonalLine.new(this._root, { themeTags: ["line"] }))
        });
        Object.defineProperty(this, "hitLine", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: this.children.push(OrthogonalLine.new(this._root, { themeTags: ["hit"] }))
        });
        Object.defineProperty(this, "startArrow", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: this.children.push(Triangle.new(this._root, {
                themeTags: ["start", "arrow"],
            }))
        });
        Object.defineProperty(this, "endArrow", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: this.children.push(Triangle.new(this._root, {
                themeTags: ["end", "arrow"],
            }))
        });
    }
    _afterNew() {
        this.addTag("link");
        super._afterNew();
    }
    _updateChildren() {
        super._updateChildren();
        if (this.isDirty("points")) {
            let points = OrthogonalLine.makeOrthogonal(this.get("points", []));
            this.line.set("points", points);
            this.hitLine.set("points", points);
            const startArrow = this.startArrow;
            const endArrow = this.endArrow;
            const len = points.length;
            if (len > 1) {
                const [start, next] = points;
                startArrow.setAll({
                    x: start.x,
                    y: start.y,
                    rotation: $math.getAngle(start, next) - 90
                });
                const last = points[len - 1];
                const prev = points[len - 2];
                endArrow.setAll({
                    x: last.x,
                    y: last.y,
                    rotation: $math.getAngle(prev, last) + 90
                });
            }
            else if (len === 1) {
                const [pt] = points;
                startArrow.setAll({ x: pt.x, y: pt.y, rotation: 0 });
                endArrow.setAll({ x: pt.x, y: pt.y, rotation: 0 });
            }
        }
    }
}
Object.defineProperty(Link, "className", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: "Link"
});
Object.defineProperty(Link, "classNames", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: Container.classNames.concat([Link.className])
});
//# sourceMappingURL=Link.js.map