import type { IPoint } from "../util/IPoint";
import { Container, IContainerSettings, IContainerPrivate } from "./Container";
import { Triangle } from "./Triangle";
import { OrthogonalLine } from "./OrthogonalLine";
export interface ILinkSettings extends IContainerSettings {
    points?: Array<IPoint>;
    cornerRadius?: number;
}
export interface ILinkPrivate extends IContainerPrivate {
}
/**
 *
 * @see {@link https://www.amcharts.com/docs/v5/concepts/common-elements/graphics/} for more info
 * @important
 */
export declare class Link extends Container {
    _settings: ILinkSettings;
    _privateSettings: ILinkPrivate;
    static className: string;
    static classNames: Array<string>;
    line: OrthogonalLine;
    hitLine: OrthogonalLine;
    startArrow: Triangle;
    endArrow: Triangle;
    protected _afterNew(): void;
    _updateChildren(): void;
}
//# sourceMappingURL=Link.d.ts.map