import { Label, ILabelPrivate, ILabelSettings, ILabelEvents } from "./Label";
import { Container } from "./Container";
import { MultiDisposer } from "../util/Disposer";
export interface IEditableLabelSettings extends ILabelSettings {
    /**
     * Start editing on click (`"click"`; default) or double-click ('"dblclick"').
     *
     * All available options:
     *
     * *`"click"` (default)
     * *`"dblclick"`
     * *`"rightclick"`
     * *`"middleclick"`
     * *`"none"`
     *
     * @default "click"
     */
    editOn?: "click" | "dblclick" | "rightclick" | "middleclick" | "none";
    /**
     * Allow multiple lines (`true` - dfault) or no (`false`).
     *
     * @default true
     * @since 5.9.6
     */
    multiLine?: boolean;
}
export interface IEditableLabelPrivate extends ILabelPrivate {
    input: Container;
    textarea: HTMLTextAreaElement;
}
export interface IEditableLabelEvents extends ILabelEvents {
    inited: {};
}
/**
 * Editable label.
 *
 * @since 5.9.5
 */
export declare class EditableLabel extends Label {
    _settings: IEditableLabelSettings;
    _privateSettings: IEditableLabelPrivate;
    _events: IEditableLabelEvents;
    static className: string;
    static classNames: Array<string>;
    protected _editOnEvents?: MultiDisposer;
    protected _afterNew(): void;
    _beforeChanged(): void;
    _prepareChildren(): void;
    _updateChildren(): void;
    protected _maybeInitTextarea(): void;
    protected _isInited(): boolean;
    protected _startEditing(): void;
    protected _stopEditing(): void;
    protected _syncStyle(): void;
    protected _syncText(): void;
}
//# sourceMappingURL=EditableLabel.d.ts.map