import { IButtonSettings, IButtonPrivate, IButtonEvents, Button } from "./Button";
export interface IConfirmButtonSettings extends IButtonSettings {
}
export interface IConfirmButtonPrivate extends IButtonPrivate {
    ConfirmButton?: Button;
}
export interface IConfirmButtonEvents extends IButtonEvents {
    confirmed: {};
    cancelled: {};
}
/**
 * Draws an interactive button, which displays a confirmation when clicked.
 *
 * @see {@link https://www.amcharts.com/docs/v5/concepts/common-elements/buttons/} for more info
 * @important
 * @since 5.14.0
 */
export declare class ConfirmButton extends Button {
    static className: string;
    static classNames: Array<string>;
    _settings: IConfirmButtonSettings;
    _privateSettings: IConfirmButtonPrivate;
    _events: IConfirmButtonEvents;
    protected _ignoreClick?: boolean;
    protected _afterNew(): void;
    protected _cancel(): void;
    protected _confirm(): void;
    _prepareChildren(): void;
}
//# sourceMappingURL=ConfirmButton.d.ts.map