import { Candlestick, ICandlestickSettings, ICandlestickPrivate } from "./Candlestick";
export interface IOHLCSettings extends ICandlestickSettings {
}
export interface IOHLCPrivate extends ICandlestickPrivate {
}
/**
 * Used to plot an OHLC graphic on an [[OHLCSeries]].
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/xy-chart/series/candlestick-series/} for more info
 * @important
 */
export declare class OHLC extends Candlestick {
    _settings: IOHLCSettings;
    _privateSettings: IOHLCPrivate;
    static className: string;
    static classNames: Array<string>;
    _draw(): void;
}
//# sourceMappingURL=OHLC.d.ts.map