import { BaseColumnSeries } from "./BaseColumnSeries";
import { Template } from "../../../core/util/Template";
import { ListTemplate } from "../../../core/util/List";
import { RoundedRectangle } from "../../../core/render/RoundedRectangle";
import { Graphics } from "../../../core/render/Graphics";
import * as $utils from "../../../core/util/Utils";
import * as $array from "../../../core/util/Array";
export class ColumnSeries extends BaseColumnSeries {
    constructor() {
        super(...arguments);
        Object.defineProperty(this, "allColumns", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: this.children.push(Graphics.new(this._root, {}))
        });
        Object.defineProperty(this, "allColumnsData", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: []
        });
        /**
         * A [[TemplateList]] of all columns in series.
         *
         * `columns.template` can be used to set default settings for all columns,
         * or to change on existing ones.
         */
        Object.defineProperty(this, "columns", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: this.addDisposer(new ListTemplate(Template.new({}), () => RoundedRectangle._new(this._root, {
                position: "absolute",
                themeTags: $utils.mergeTags(this.columns.template.get("themeTags", []), ["series", "column"])
            }, [this.columns.template])))
        });
    }
    /**
     * @ignore
     */
    makeColumn(dataItem, listTemplate) {
        const column = listTemplate.make();
        if (!this.get("turboMode")) {
            this.mainContainer.children.push(column);
        }
        else {
            column.virtualParent = this.chart;
        }
        column._setDataItem(dataItem);
        listTemplate.push(column);
        return column;
    }
    _processAxisRange(axisRange) {
        super._processAxisRange(axisRange);
        axisRange.columns = new ListTemplate(Template.new({}), () => RoundedRectangle._new(this._root, {
            position: "absolute",
            themeTags: $utils.mergeTags(axisRange.columns.template.get("themeTags", []), ["series", "column"]),
        }, [this.columns.template, axisRange.columns.template]));
    }
    _beforeColumnsDraw() {
        this.allColumnsData = [];
    }
    _afterColumnsDraw() {
        if (this.get("turboMode")) {
            this.allColumns.set("draw", (display) => {
                display.clear();
                $array.each(this.allColumnsData, (column) => {
                    const w = column.width;
                    const h = column.height;
                    const x = column.x;
                    const y = column.y;
                    const stroke = column.stroke;
                    const fill = column.fill;
                    const strokeWidth = column.strokeWidth;
                    const strokeOpacity = column.strokeOpacity;
                    const fillOpacity = column.fillOpacity;
                    display.beginFill(fill, fillOpacity);
                    display.beginPath();
                    display.lineStyle(strokeWidth, stroke, strokeOpacity);
                    display.drawRect(x, y, w, h);
                    display.endStroke();
                    display.endFill();
                });
            });
        }
    }
    _updateSeriesGraphics(dataItem, graphics, l, r, t, b, fitW, fitH) {
        if (this.get("turboMode")) {
            const stroke = graphics.get("stroke");
            const fillOpacity = graphics.get("fillOpacity", 1);
            const strokeOpacity = graphics.get("strokeOpacity", 1);
            const strokWidth = graphics.get("strokeWidth", 1);
            const fill = graphics.get("fill");
            const ptl = this.getPoint(l, t);
            const pbr = this.getPoint(r, b);
            const tooltipPoint = dataItem.get("point");
            if (tooltipPoint) {
                const point = this.getPoint(tooltipPoint.x, tooltipPoint.y);
                tooltipPoint.x = point.x + this._x;
                tooltipPoint.y = point.y + this._y;
            }
            l = ptl.x;
            r = pbr.x;
            t = ptl.y;
            b = pbr.y;
            dataItem.setRaw("left", l);
            dataItem.setRaw("right", r);
            dataItem.setRaw("top", t);
            dataItem.setRaw("bottom", b);
            this.allColumnsData.push({ width: r - l, height: b - t, x: l, y: t, stroke: stroke, fill: fill, strokeWidth: strokWidth, strokeOpacity: strokeOpacity, fillOpacity: fillOpacity });
        }
        else {
            super._updateSeriesGraphics(dataItem, graphics, l, r, t, b, fitW, fitH);
        }
    }
}
Object.defineProperty(ColumnSeries, "className", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: "ColumnSeries"
});
Object.defineProperty(ColumnSeries, "classNames", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: BaseColumnSeries.classNames.concat([ColumnSeries.className])
});
//# sourceMappingURL=ColumnSeries.js.map