import type { DataItem } from "../../../core/render/Component";
import type { Color } from "../../../core/util/Color";
import { BaseColumnSeries, IBaseColumnSeriesPrivate, IBaseColumnSeriesSettings, IBaseColumnSeriesDataItem, IBaseColumnSeriesAxisRange } from "./BaseColumnSeries";
import { ListTemplate } from "../../../core/util/List";
import { RoundedRectangle } from "../../../core/render/RoundedRectangle";
import { Graphics } from "../../../core/render/Graphics";
export interface IColumnSeriesDataItem extends IBaseColumnSeriesDataItem {
}
export interface IColumnSeriesSettings extends IBaseColumnSeriesSettings {
    /**
     * Enables "turbo mode" of rendering.
     *
     * If enabled, the columsn will be drawn directly on canvas, rather than
     * each individually, significantly speeding up the rendering. Especially
     * on column-heavy charts.
     *
     * NOTE: this is an experimental feature and may not work in all setups. Some
     * features might be disabled, too, e.g. pointer events and rounded corners.
     *
     * @since 5.14.0
     * @see {@link https://www.amcharts.com/docs/v5/charts/xy-chart/series/column-series/#Turbo_mode} for more info
     */
    turboMode?: boolean;
}
export interface IColumnSeriesPrivate extends IBaseColumnSeriesPrivate {
}
export interface IColumnSeriesAxisRange extends IBaseColumnSeriesAxisRange {
    /**
     * A list of actual columns in a range.
     */
    columns: ListTemplate<RoundedRectangle>;
}
export declare class ColumnSeries extends BaseColumnSeries {
    _settings: IColumnSeriesSettings;
    _privateSettings: IColumnSeriesPrivate;
    _dataItemSettings: IColumnSeriesDataItem;
    _axisRangeType: IColumnSeriesAxisRange;
    allColumns: Graphics;
    allColumnsData: Array<{
        width: number;
        height: number;
        x: number;
        y: number;
        lowX0?: number;
        lowY0?: number;
        lowX1?: number;
        lowY1?: number;
        highX0?: number;
        highY0?: number;
        highX1?: number;
        highY1?: number;
        stroke?: Color;
        fill?: Color;
        strokeWidth: number;
        strokeOpacity: number;
        fillOpacity: number;
    }>;
    /**
     * @ignore
     */
    makeColumn(dataItem: DataItem<this["_dataItemSettings"]>, listTemplate: ListTemplate<RoundedRectangle>): RoundedRectangle;
    /**
     * A [[TemplateList]] of all columns in series.
     *
     * `columns.template` can be used to set default settings for all columns,
     * or to change on existing ones.
     */
    readonly columns: ListTemplate<RoundedRectangle>;
    static className: string;
    static classNames: Array<string>;
    protected _processAxisRange(axisRange: this["_axisRangeType"]): void;
    protected _beforeColumnsDraw(): void;
    protected _afterColumnsDraw(): void;
    protected _updateSeriesGraphics(dataItem: DataItem<this["_dataItemSettings"]>, graphics: Graphics, l: number, r: number, t: number, b: number, fitW: boolean, fitH: boolean): void;
}
//# sourceMappingURL=ColumnSeries.d.ts.map