import { EditableLabel } from "../../../core/render/EditableLabel";
/**
 * Draws an axis label.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/xy-chart/axes/#Labels} for more info
 * @important
 */
export class EditableAxisLabel extends EditableLabel {
    constructor() {
        super(...arguments);
        Object.defineProperty(this, "_tickPoints", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: []
        });
    }
}
Object.defineProperty(EditableAxisLabel, "className", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: "EditableAxisLabel"
});
Object.defineProperty(EditableAxisLabel, "classNames", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: EditableLabel.classNames.concat([EditableAxisLabel.className])
});
//# sourceMappingURL=EditableAxisLabel.js.map