import type { IAxisLabel } from "./AxisLabel";
import type { IPoint } from "../../../core/util/IPoint";
import { EditableLabel, IEditableLabelPrivate, IEditableLabelSettings } from "../../../core/render/EditableLabel";
export interface IEditableAxisLabelSettings extends IEditableLabelSettings {
}
export interface IEditableAxisLabelPrivate extends IEditableLabelPrivate {
}
/**
 * Draws an axis label.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/xy-chart/axes/#Labels} for more info
 * @important
 */
export declare class EditableAxisLabel extends EditableLabel implements IAxisLabel {
    _settings: IEditableAxisLabelSettings;
    _privateSettings: IEditableAxisLabelPrivate;
    static className: string;
    static classNames: Array<string>;
    _tickPoints: Array<IPoint>;
}
//# sourceMappingURL=EditableAxisLabel.d.ts.map