import { CurveChart } from "./CurveChart";
import { p50 } from "../../core/util/Percent";
import * as $math from "../../core/util/Math";
import * as $utils from "../../core/util/Utils";
/**
 * A spiral chart.
 *
 * For this chart to work, it needs curve points provided via renderer of
 * its X-axis.
 *
 * Note: it is an experimental chart type and does not support all the
 * functionality of the [[XYChart]].
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/timeline/} for more info
 * @since 5.12.0
 * @important
 */
export class SpiralChart extends CurveChart {
    _prepareChildren() {
        super._prepareChildren();
        if (this.isDirty("levelCount")) {
            this._updateMasks();
        }
    }
    _updateMasks() {
        let w = this.plotContainer.innerWidth();
        let h = this.plotContainer.innerHeight();
        let radius = Math.min(w, h) / 2;
        let innerRadius = $utils.relativeToValue(this.get("innerRadius", 0), radius);
        let radiusStep = (radius - innerRadius) / this.get("levelCount", 1);
        let yAxisRadius = $utils.relativeToValue(this.get("yAxisRadius", p50), radiusStep);
        const points = $math.spiralPoints(0, 0, radius, radius, innerRadius, 20, radiusStep, this.get("startAngle", 0), this.get("endAngle", 360));
        this.yAxes.each((axis) => {
            const renderer = axis.get("renderer");
            renderer.set("axisLength", yAxisRadius);
            axis.markDirtySize();
        });
        this.xAxes.each((axis) => {
            const renderer = axis.get("renderer");
            renderer.setPrivate("autoScale", false);
            renderer.set("points", points);
        });
        super._updateMasks();
    }
}
Object.defineProperty(SpiralChart, "className", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: "SpiralChart"
});
Object.defineProperty(SpiralChart, "classNames", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: CurveChart.classNames.concat([SpiralChart.className])
});
//# sourceMappingURL=SpiralChart.js.map