import type { CurveColumnSeries } from "./CurveColumnSeries";
import { CurveChart, ICurveChartPrivate, ICurveChartSettings } from "./CurveChart";
import { Percent } from "../../core/util/Percent";
export interface ISpiralChartSettings extends ICurveChartSettings {
    /**
     * Numer of spiral circles.
     *
     * @default 3
     */
    levelCount?: number;
    /**
     * y Axis radius in percent.
     *
     * @defgault 50%
     */
    yAxisRadius?: Percent;
    /**
     * Start angle of the spiral in degrees.
     *
     * @default -90
     */
    startAngle?: number;
    /**
     * End angle of the spiral in degrees.
     *
     * default 0
     */
    endAngle?: number;
    /**
     * Inner radius of the spiral in percent.
     *
     * @default 60%
     */
    innerRadius?: Percent;
}
export interface ISpiralChartPrivate extends ICurveChartPrivate {
}
/**
 * A spiral chart.
 *
 * For this chart to work, it needs curve points provided via renderer of
 * its X-axis.
 *
 * Note: it is an experimental chart type and does not support all the
 * functionality of the [[XYChart]].
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/timeline/} for more info
 * @since 5.12.0
 * @important
 */
export declare class SpiralChart extends CurveChart {
    static className: string;
    static classNames: Array<string>;
    _settings: ISpiralChartSettings;
    _privateSettings: ISpiralChartPrivate;
    _seriesType: CurveColumnSeries;
    _prepareChildren(): void;
    _updateMasks(): void;
}
//# sourceMappingURL=SpiralChart.d.ts.map