import type { CurveColumnSeries } from "./CurveColumnSeries";
import { CurveChart, ICurveChartPrivate, ICurveChartSettings } from "./CurveChart";
import { Percent } from "../../core/util/Percent";
export interface ISerpentineChartSettings extends ICurveChartSettings {
    /**
     * Orientation of the serpatine.
     *
     * @default "vertical"
     */
    orientation?: "horizontal" | "vertical";
    /**
     * Number of levels in the chart.
     *
     * @default 3
     */
    levelCount?: number;
    /**
     * Radius of the Y-axis in `Percent`.
     *
     * @default 50%
     */
    yAxisRadius?: Percent;
    /**
     * Relative location (0-1) of the start postion.
     *
     * @defult 0
     */
    startLocation?: number;
    /**
     * Relative location (0-1) of the end position.
     *
     * @defult 1
     */
    endLocation?: number;
}
export interface ISerpentineChartPrivate extends ICurveChartPrivate {
}
/**
 * A Serpentine chart.
 *
 * For this chart to work, it needs curve points provided via renderer of
 * its X-axis.
 *
 * Note: it is an experimental chart type and does not support all the
 * functionality of the [[XYChart]].
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/timeline/} for more info
 * @since 5.12.0
 * @important
 */
export declare class SerpentineChart extends CurveChart {
    static className: string;
    static classNames: Array<string>;
    _settings: ISerpentineChartSettings;
    _privateSettings: ISerpentineChartPrivate;
    _seriesType: CurveColumnSeries;
    _prepareChildren(): void;
    _updateMasks(): void;
}
//# sourceMappingURL=SerpentineChart.d.ts.map