import { Graphics } from "../../core/render/Graphics";
import { LineSeries } from "../xy/series/LineSeries";
/**
 * A line series for use in a [[CurveChart]], [[SerpetineChart]], or
 * a [[SpiralChart]].
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/timeline/} for more info
 * @since 5.12.0
 * @important
 */
export class CurveLineSeries extends LineSeries {
    _afterNew() {
        super._afterNew();
        this.set("maskContent", false);
        this.bulletsContainer.set("maskContent", false);
        this.bulletsContainer.set("mask", Graphics.new(this._root, {}));
    }
    _handleMaskBullets() {
    }
    _updateChildren() {
        super._updateChildren();
        if (!this.get("maskBullets")) {
            this.bulletsContainer.remove("mask");
        }
    }
    getPoint(positionX, positionY) {
        const xRenderer = this.get("xAxis").get("renderer");
        return xRenderer.positionToPoint(positionX, positionY);
    }
    _shouldInclude(position) {
        const xAxis = this.get("xAxis");
        if (position < xAxis.get("start", 0) || position > xAxis.get("end", 1)) {
            return false;
        }
        return true;
    }
    _shouldShowBullet(positionX, _positionY) {
        const xAxis = this.get("xAxis");
        if (positionX < xAxis.get("start", 0) || positionX > xAxis.get("end", 1)) {
            return false;
        }
        return this._showBullets;
    }
    _positionBullet(bullet) {
        let sprite = bullet.get("sprite");
        if (sprite) {
            const dataItem = sprite.dataItem;
            const diLocationX = dataItem.get("locationX", 0.5);
            const diLocationY = dataItem.get("locationY", 0.5);
            const locationX = bullet.get("locationX", diLocationX);
            const locationY = bullet.get("locationY", diLocationY);
            const series = dataItem.component;
            const xAxis = series.get("xAxis");
            const yAxis = series.get("yAxis");
            let positionX = 0;
            let vcx = series.get("vcx", 1);
            let vcy = series.get("vcy", 1);
            if (this.get("openValueXField")) {
                const p0 = xAxis.getDataItemPositionX(dataItem, series._xOpenField, diLocationX, vcx);
                const p1 = xAxis.getDataItemPositionX(dataItem, series._xField, diLocationX, vcx);
                positionX = p0 + (p1 - p0) * locationX;
            }
            else {
                positionX = xAxis.getDataItemPositionX(dataItem, series._xField, locationX, vcx);
            }
            let positionY = 0;
            if (this.get("openValueYField")) {
                const p0 = yAxis.getDataItemPositionY(dataItem, series._yOpenField, diLocationY, vcy);
                const p1 = yAxis.getDataItemPositionY(dataItem, series._yField, diLocationY, vcy);
                positionY = p0 + (p1 - p0) * locationY;
            }
            else {
                positionY = yAxis.getDataItemPositionY(dataItem, series._yField, locationY, vcy);
            }
            if (series._shouldShowBullet(positionX, positionY)) {
                sprite.setPrivate("visible", true);
                const point = series.getPoint(positionX, positionY);
                sprite.setAll({
                    x: point.x,
                    y: point.y
                });
            }
            else {
                sprite.setPrivate("visible", false);
            }
        }
    }
}
Object.defineProperty(CurveLineSeries, "className", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: "CurveLineSeries"
});
Object.defineProperty(CurveLineSeries, "classNames", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: LineSeries.classNames.concat([CurveLineSeries.className])
});
//# sourceMappingURL=CurveLineSeries.js.map