import type { IPoint } from "../../core/util/IPoint";
import type { Bullet } from "../../core/render/Bullet";
import type { CurveChart } from "./CurveChart";
import { LineSeries, ILineSeriesPrivate, ILineSeriesSettings, ILineSeriesDataItem, ILineSeriesAxisRange } from "../xy/series/LineSeries";
export interface ICurveLineSeriesDataItem extends ILineSeriesDataItem {
}
export interface ICurveLineSeriesSettings extends ILineSeriesSettings {
}
export interface ICurveLineSeriesPrivate extends ILineSeriesPrivate {
}
export interface ICurveLineSeriesAxisRange extends ILineSeriesAxisRange {
}
/**
 * A line series for use in a [[CurveChart]], [[SerpetineChart]], or
 * a [[SpiralChart]].
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/timeline/} for more info
 * @since 5.12.0
 * @important
 */
export declare class CurveLineSeries extends LineSeries {
    _settings: ICurveLineSeriesSettings;
    _privateSettings: ICurveLineSeriesPrivate;
    _dataItemSettings: ICurveLineSeriesDataItem;
    _axisRangeType: ICurveLineSeriesAxisRange;
    /**
     * A chart series belongs to.
     */
    chart: CurveChart | undefined;
    static className: string;
    static classNames: Array<string>;
    protected _afterNew(): void;
    protected _handleMaskBullets(): void;
    _updateChildren(): void;
    getPoint(positionX: number, positionY: number): IPoint;
    protected _shouldInclude(position: number): boolean;
    protected _shouldShowBullet(positionX: number, _positionY: number): boolean;
    _positionBullet(bullet: Bullet): void;
}
//# sourceMappingURL=CurveLineSeries.d.ts.map