import { XYCursor } from "../xy/XYCursor";
import * as $utils from "../../core/util/Utils";
import * as $array from "../../core/util/Array";
/**
 * A chart cursor for use in a [[CurveChart]], [[SerpetineChart]], or
 * a [[SpiralChart]].
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/timeline/} for more info
 * @since 5.12.0
 * @important
 */
export class CurveCursor extends XYCursor {
    _afterNew() {
        this._settings.themeTags = $utils.mergeTags(this._settings.themeTags, ["curve", "cursor"]);
        super._afterNew();
    }
    _handleXLine() {
    }
    _handleYLine() {
    }
    _getPosition(point) {
        const xRenderer = this.get("xAxis").get("renderer");
        return xRenderer.pointToPosition(point);
    }
    _getPoint(positionX, positionY) {
        const xRenderer = this.get("xAxis").get("renderer");
        return xRenderer.positionToPoint(positionX, positionY);
    }
    /**
     * @ignore
     */
    updateLayout() {
    }
    _updateLines(x, y) {
        if (!this._tooltipX) {
            this._drawXLine(x, y);
        }
        if (!this._tooltipY) {
            this._drawYLine(x, y);
        }
    }
    _drawXLine(_x, _y) {
        const xAxis = this.get("xAxis");
        const yAxis = this.get("yAxis");
        const renderer = xAxis.get("renderer");
        const position = renderer.toAxisPosition(this.getPrivate("positionX", 0));
        const p0 = renderer.positionToPoint(position, yAxis.get("start", 0));
        const p1 = renderer.positionToPoint(position, yAxis.get("end", 1));
        this.lineX.set("draw", (display) => {
            display.moveTo(p0.x, p0.y);
            display.lineTo(p1.x, p1.y);
        });
    }
    _drawYLine(_x, _y) {
        const xAxis = this.get("xAxis");
        const yAxis = this.get("yAxis");
        const renderer = yAxis.get("renderer");
        const position = 1 - renderer.toAxisPosition(this.getPrivate("positionY", 0));
        const points = renderer.getPoints(xAxis.get("start", 0), position, xAxis.get("end", 1), position);
        if (points) {
            if (position > yAxis.get("start", 0) && position < yAxis.get("end", 1)) {
                this.lineY.set("draw", (display) => {
                    if (points.length > 0) {
                        display.moveTo(points[0].x, points[0].y);
                        $array.each(points, (point) => {
                            display.lineTo(point.x, point.y);
                        });
                    }
                });
            }
            else {
                this.lineY.set("draw", (display) => {
                    display.clear();
                });
            }
        }
    }
    _updateXLine(tooltip) {
        let point = tooltip.get("pointTo");
        if (point) {
            this._drawXLine(point.x, point.y);
        }
    }
    _updateYLine(tooltip) {
        let point = tooltip.get("pointTo");
        if (point) {
            this._drawYLine(point.x, point.y);
        }
    }
    _inPlot() {
        const chart = this.chart;
        if (chart) {
        }
        return true;
    }
    _updateSelection() {
        this.selection.set("draw", (display) => {
            const behavior = this.get("behavior");
            let xAxis = this.get("xAxis");
            let yAxis = this.get("yAxis");
            let downPositionX = xAxis.toAxisPosition(this.getPrivate("downPositionX", 0));
            let downPositionY = yAxis.toAxisPosition(this.getPrivate("downPositionY", 0));
            let positionX = xAxis.toAxisPosition(this.getPrivate("positionX", 0));
            let positionY = yAxis.toAxisPosition(this.getPrivate("positionY", 0));
            if (behavior == "zoomX" || behavior == "selectX") {
                downPositionY = yAxis.get("start", 0);
                positionY = yAxis.get("end", 1);
            }
            else if (behavior == "zoomY" || behavior == "selectY") {
                downPositionX = xAxis.get("start", 0);
                positionX = xAxis.get("end", 1);
            }
            const points = xAxis.get("renderer").getPoints(downPositionX, downPositionY, positionX, positionY);
            display.moveTo(points[0].x, points[0].y);
            $array.each(points, (point) => {
                display.lineTo(point.x, point.y);
            });
            display.closePath();
        });
    }
}
Object.defineProperty(CurveCursor, "className", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: "CurveCursor"
});
Object.defineProperty(CurveCursor, "classNames", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: XYCursor.classNames.concat([CurveCursor.className])
});
//# sourceMappingURL=CurveCursor.js.map