import type { IPoint } from "../../core/util/IPoint";
import type { Tooltip } from "../../core/render/Tooltip";
import type { CurveChart } from "./CurveChart";
import type { AxisRendererCurveX } from "./AxisRendererCurveX";
import type { AxisRendererCurveY } from "./AxisRendererCurveY";
import type { Axis } from "../xy/axes/Axis";
import { XYCursor, IXYCursorSettings, IXYCursorPrivate, IXYCursorEvents } from "../xy/XYCursor";
export interface ICurveCursorSettings extends IXYCursorSettings {
    /**
     * A target X-axis.
     *
     * Differently from the `XYChart`, this setting is required for cursor to work.
     */
    xAxis: Axis<AxisRendererCurveX>;
    /**
     * A target Y-axis.
     *
     * Differently from the `XYChart`, this setting is required for cursor to work.
     */
    yAxis: Axis<AxisRendererCurveY>;
}
export interface ICurveCursorPrivate extends IXYCursorPrivate {
}
export interface ICurveCursorEvents extends IXYCursorEvents {
}
/**
 * A chart cursor for use in a [[CurveChart]], [[SerpetineChart]], or
 * a [[SpiralChart]].
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/timeline/} for more info
 * @since 5.12.0
 * @important
 */
export declare class CurveCursor extends XYCursor {
    static className: string;
    static classNames: Array<string>;
    _settings: ICurveCursorSettings;
    _privateSettings: ICurveCursorPrivate;
    _events: ICurveCursorEvents;
    /**
     * A chart cursor is attached to.
     */
    chart: CurveChart | undefined;
    protected _afterNew(): void;
    protected _handleXLine(): void;
    protected _handleYLine(): void;
    protected _getPosition(point: IPoint): IPoint;
    protected _getPoint(positionX: number, positionY: number): IPoint;
    /**
     * @ignore
     */
    updateLayout(): void;
    protected _updateLines(x: number, y: number): void;
    protected _drawXLine(_x: number, _y: number): void;
    protected _drawYLine(_x: number, _y: number): void;
    protected _updateXLine(tooltip: Tooltip): void;
    protected _updateYLine(tooltip: Tooltip): void;
    protected _inPlot(): boolean;
    protected _updateSelection(): void;
}
//# sourceMappingURL=CurveCursor.d.ts.map