import type { DataItem } from "../../core/render/Component";
import type { IPoint } from "../../core/util/IPoint";
import type { Bullet } from "../../core/render/Bullet";
import type { CurveChart } from "./CurveChart";
import { BaseColumnSeries, IBaseColumnSeriesPrivate, IBaseColumnSeriesSettings, IBaseColumnSeriesDataItem, IBaseColumnSeriesAxisRange } from "../xy/series/BaseColumnSeries";
import { Graphics } from "../../core/render/Graphics";
import { ListTemplate } from "../../core/util/List";
import { Polygon } from "../../core/render/Polygon";
export interface ICurveColumnSeriesDataItem extends IBaseColumnSeriesDataItem {
}
export interface ICurveColumnSeriesSettings extends IBaseColumnSeriesSettings {
}
export interface ICurveColumnSeriesPrivate extends IBaseColumnSeriesPrivate {
}
export interface ICurveColumnSeriesAxisRange extends IBaseColumnSeriesAxisRange {
    /**
     * List of columns in a range.
     */
    columns: ListTemplate<Polygon>;
}
/**
 * A column series for use in a [[CurveChart]], [[SerpetineChart]], or
 * a [[SpiralChart]].
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/timeline/} for more info
 * @since 5.12.0
 * @important
 */
export declare class CurveColumnSeries extends BaseColumnSeries {
    _settings: ICurveColumnSeriesSettings;
    _privateSettings: ICurveColumnSeriesPrivate;
    _dataItemSettings: ICurveColumnSeriesDataItem;
    _axisRangeType: ICurveColumnSeriesAxisRange;
    /**
     * @ignore
     */
    makeColumn(dataItem: DataItem<this["_dataItemSettings"]>, listTemplate: ListTemplate<Polygon>): Polygon;
    /**
     * A [[TemplateList]] of all columns in series.
     *
     * `columns.template` can be used to set default settings for all columns,
     * or to change on existing ones.
     *
     * @default new ListTemplate<Polygon>
     */
    readonly columns: ListTemplate<Polygon>;
    static className: string;
    static classNames: Array<string>;
    /**
     * A chart series belongs to.
     */
    chart: CurveChart | undefined;
    protected _afterNew(): void;
    /**
     * @ignore
     */
    getPoint(positionX: number, positionY: number): IPoint;
    protected _updateSeriesGraphics(dataItem: DataItem<this["_dataItemSettings"]>, graphics: Graphics, l: number, r: number, t: number, b: number): void;
    protected _shouldInclude(position: number): boolean;
    protected _shouldShowBullet(positionX: number, _positionY: number): boolean;
    _positionBullet(bullet: Bullet): void;
    protected _handleMaskBullets(): void;
    _updateChildren(): void;
    protected _processAxisRange(axisRange: this["_axisRangeType"]): void;
}
//# sourceMappingURL=CurveColumnSeries.d.ts.map