import type { AxisRendererCurveX } from "./AxisRendererCurveX";
import type { AxisRendererCurveY } from "./AxisRendererCurveY";
import type { Axis } from "../xy/axes/Axis";
import type { CurveCursor } from "./CurveCursor";
import type { CurveColumnSeries } from "./CurveColumnSeries";
import type { IPoint } from "../../core/util/IPoint";
import { XYChart, IXYChartPrivate, IXYChartSettings } from "../xy/XYChart";
import { Container } from "../../core/render/Container";
export interface ICurveChartSettings extends IXYChartSettings {
    /**
     * [[CurveCursor]] instance.
     *
     * @see {@link https://www.amcharts.com/docs/v5/charts/timeline-chart/#Cursor} for more info
     */
    cursor?: CurveCursor;
}
export interface ICurveChartPrivate extends IXYChartPrivate {
}
/**
 * Base chart for a Timeline chart.
 *
 * For this chart to work, it needs curve points provided via renderer of
 * its X-axis.
 *
 * Note: it is an experimental chart type and does not support all the
 * functionality of the [[XYChart]].
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/timeline/} for more info
 * @since 5.12.0
 * @important
 */
export declare class CurveChart extends XYChart {
    /**
     * [[Container]] where chart elements go.
     *
     * @default Container.new()
     */
    readonly curveContainer: Container;
    static className: string;
    static classNames: Array<string>;
    _settings: ICurveChartSettings;
    _privateSettings: ICurveChartPrivate;
    _seriesType: CurveColumnSeries;
    protected _afterNew(): void;
    protected _maskGrid(): void;
    protected _addCursor(cursor: CurveCursor): void;
    _updateMasks(): void;
    /**
     * @ignore
     */
    _updateMask(container: Container): void;
    /**
     * @ignore
     */
    processAxis(axis: Axis<AxisRendererCurveY | AxisRendererCurveX>): void;
    /**
     * @ignore
     */
    inPlot(_point: IPoint): boolean;
    protected _tooltipToLocal(point: IPoint): IPoint;
    protected _handlePinch(): void;
}
//# sourceMappingURL=CurveChart.d.ts.map