import type { CurveChart } from "./CurveChart";
import type { Grid } from "../xy/axes/Grid";
import type { IPoint } from "../../core/util/IPoint";
import type { Graphics } from "../../core/render/Graphics";
import type { AxisTick } from "../xy/axes/AxisTick";
import type { AxisBullet } from "../xy/axes/AxisBullet";
import type { Tooltip } from "../../core/render/Tooltip";
import type { AxisRendererCurveX } from "./AxisRendererCurveX";
import { AxisRenderer, IAxisRendererSettings, IAxisRendererPrivate } from "../xy/axes/AxisRenderer";
import { AxisLabelRadial } from "../xy/axes/AxisLabelRadial";
import { ListTemplate } from "../../core/util/List";
export interface IAxisRendererCurveYSettings extends IAxisRendererSettings {
    /**
     * Axis length in pixels.
     *
     * [[SerpentineChart]] and [[SpiralChart]] will ignore this setting as they
     * calculate axis length by the `yAxisRadius` setting of a chart itself.
     *
     * @default 60
     */
    axisLength?: number;
    /**
     * X-axis renderer.
     *
     * This setting is required.
     */
    xRenderer?: AxisRendererCurveX;
    /**
    * Relative location of the axis on the chart: 0-1.
    *
    * * `0` - start
    * * `1` - end
    *
    * @default 0.5
    */
    axisLocation?: number;
    /**
     * Should axis labels rotation should be adjusted to the axis rotation?
     *
     * @default false
     */
    rotateLabels?: boolean;
}
export interface IAxisRendererCurveYPrivate extends IAxisRendererPrivate {
}
/**
 * Renderer for [[CurveChart]] "vertical" axes.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/timeline/} for more info
 * @since 5.12.0
 * @important
 */
export declare class AxisRendererCurveY extends AxisRenderer {
    /**
     * Chart this renderer is for.
     */
    chart: CurveChart | undefined;
    static className: string;
    static classNames: Array<string>;
    _settings: IAxisRendererCurveYSettings;
    _privateSettings: IAxisRendererCurveYPrivate;
    protected _fillGenerator: import("d3-shape").Arc<any, import("d3-shape").DefaultArcObject>;
    /**
     * A [[TemplateList]] with all the labels attached to the axis.
     *
     * `labels.template` can be used to configure appearance of the labels.
     *
     * @default new ListTemplate<AxisLabelRadial>
     */
    readonly labels: ListTemplate<AxisLabelRadial>;
    _afterNew(): void;
    _changed(): void;
    /**
     * @ignore
     */
    processAxis(): void;
    /**
     * @ignore
     */
    updateLayout(): void;
    /**
     * @ignore
     */
    updateGrid(grid?: Grid, position?: number, endPosition?: number): void;
    protected _handleOpposite(): void;
    /**
     * Converts relative position to X/Y point.
     *
     * @param   position  Position
     * @return            Point
     */
    positionToPoint(position: number, positionX?: number, doNotFix?: boolean): IPoint;
    /**
     * @ignore
     */
    updateLabel(label?: AxisLabelRadial, position?: number, endPosition?: number, count?: number): void;
    /**
     * @ignore
     */
    updateTick(tick?: AxisTick, position?: number, endPosition?: number, count?: number): void;
    /**
     * @ignore
     */
    updateBullet(bullet?: AxisBullet, position?: number, endPosition?: number): void;
    getPoints(positionX: number, positionY: number, endPositionX: number, endPositionY: number): IPoint[] | undefined;
    /**
     * @ignore
     */
    updateFill(fill?: Graphics, position?: number, endPosition?: number): void;
    /**
     * Returns axis length in pixels.
     *
     * @return Length
     */
    axisLength(): number;
    /**
     * @ignore
     */
    updateTooltipBounds(_tooltip: Tooltip): void;
    /**
     * Converts relative position to pixels.
     *
     * @param   position  Position
     * @return            Pixels
     */
    positionToCoordinate(position: number): number;
    /**
     * @ignore
     */
    positionTooltip(tooltip: Tooltip, position: number): void;
}
//# sourceMappingURL=AxisRendererCurveY.d.ts.map