import type { CurveChart } from "./CurveChart";
import type { Grid } from "../xy/axes/Grid";
import type { IPoint } from "../../core/util/IPoint";
import type { AxisTick } from "../xy/axes/AxisTick";
import type { AxisBullet } from "../xy/axes/AxisBullet";
import type { Tooltip } from "../../core/render/Tooltip";
import type { AxisRendererCurveY } from "./AxisRendererCurveY";
import { Slice } from "../../core/render/Slice";
import { AxisRenderer, IAxisRendererSettings, IAxisRendererPrivate } from "../xy/axes/AxisRenderer";
import { AxisLabel } from "../xy/axes/AxisLabel";
import { ListTemplate } from "../../core/util/List";
export interface IAxisRendererCurveXSettings extends IAxisRendererSettings {
    /**
     * Array of control points to draw axis along.
     */
    points?: Array<IPoint>;
    /**
     * Y renderer of a Y axis. Must be defined!
     */
    yRenderer: AxisRendererCurveY;
    /**
     * If labels rotation should be adjusted to the axis rotation
     */
    rotateLabels?: boolean;
}
export interface IAxisRendererCurveXPrivate extends IAxisRendererPrivate {
    scale?: number;
    centerX?: number;
    centerY?: number;
    axisLength?: number;
    autoScale?: boolean;
}
/**
 * Renderer for [[CurveChart]] "horizontal" axes.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/timeline/} for more info
 * @since 5.12.0
 * @important
 */
export declare class AxisRendererCurveX extends AxisRenderer {
    /**
     * Chart this renderer is for.
     */
    chart: CurveChart | undefined;
    /**
     * A list of labels in the axis.
     *
     * `labels.template` can be used to configure labels.
     *
     * @default new ListTemplate<AxisLabelRadial>
     */
    readonly labels: ListTemplate<AxisLabel>;
    /**
     * A list of fills in the axis.
     *
     * `axisFills.template` can be used to configure axis fills.
     *
     * @default new ListTemplate<Slice>
     */
    readonly axisFills: ListTemplate<Slice>;
    static className: string;
    static classNames: Array<string>;
    _settings: IAxisRendererCurveXSettings;
    _privateSettings: IAxisRendererCurveXPrivate;
    pointPostion: Array<number>;
    pointDistance: Array<number>;
    protected _normalizedPoints: Array<IPoint>;
    _afterNew(): void;
    _beforeChanged(): void;
    /**
     * @ignore
     */
    processAxis(): void;
    /**
     * @ignore
     */
    _updateLayout(): void;
    /**
     * @ignore
     */
    updateGrid(grid?: Grid, position?: number, endPosition?: number): void;
    /**
     * Converts relative position to angle.
     *
     * @param   position  Position
     * @return            Angle
     */
    positionToAngle(position: number): number;
    getPoints(positionX: number, positionY: number, endPositionX: number, endPositionY: number): IPoint[];
    protected _handleOpposite(): void;
    positionToIndex(position: number): number;
    indexToPosition(index: number): number;
    pointToPosition(point: IPoint): IPoint;
    /**
     * Converts relative position to an X/Y coordinate.
     *
     * @param   position  Position
     * @return            Point
     */
    positionToPoint(position: number, positionY?: number, doNotFix?: boolean): IPoint;
    /**
     * @ignore
     */
    updateLabel(label?: AxisLabel, position?: number, endPosition?: number, count?: number): void;
    /**
     * @ignore
     */
    updateTick(tick?: AxisTick, position?: number, endPosition?: number, count?: number): void;
    /**
     * @ignore
     */
    updateBullet(bullet?: AxisBullet, position?: number, endPosition?: number): void;
    /**
     * @ignore
     */
    updateFill(fill?: Slice, position?: number, endPosition?: number): void;
    /**
     * Returns axis length in pixels.
     *
     * @return Length
     */
    axisLength(): number;
    /**
     * @ignore
     */
    positionTooltip(tooltip: Tooltip, position: number): void;
    /**
     * @ignore
     */
    updateTooltipBounds(_tooltip: Tooltip): void;
}
//# sourceMappingURL=AxisRendererCurveX.d.ts.map