import type { Color } from "../../../core/util/Color";
import type { Graphics } from "../../../core/render/Graphics";
import type { XYSeries } from "../../xy/series/XYSeries";
import { AxisRendererX } from "../../xy/axes/AxisRendererX";
import { ValueAxis } from "../../xy/axes/ValueAxis";
import { Indicator, IIndicatorSettings, IIndicatorPrivate, IIndicatorEvents, IIndicatorEditableSetting } from "./Indicator";
import { ColumnSeries } from "../../xy/series/ColumnSeries";
export interface IVolumeProfileSettings extends IIndicatorSettings {
    /**
     * Volume up color.
     */
    upColor?: Color;
    /**
     * Volume down color.
     */
    downColor?: Color;
    /**
     * Type of count.
     */
    countType?: "rows" | "ticks";
    /**
     * Number of rows or number of ticks, depending on the countType.
     *
     * @default 24
     */
    count?: number;
    /**
     * Max width of columns in percent (%).
     *
     * @default 40
     */
    axisWidth?: number;
    /**
     * Specifies what percentage of all volume for the trading session should
     * be highlighted by Value Area.
     *
     * @default 70
     */
    valueArea?: number;
    /**
     * Opacity of columns which fall withing value area.
     *
     * @default .7
     */
    valueAreaOpacity?: number;
    /**
     * Chart's main volume series.
     */
    volumeSeries: XYSeries;
}
export interface IVolumeProfilePrivate extends IIndicatorPrivate {
}
export interface IVolumeProfileEvents extends IIndicatorEvents {
}
/**
 * An implementation of a Volume Profile indicator for a [[StockChart]].
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/stock/indicators/} for more info
 * @since 5.7.0
 */
export declare class VolumeProfile extends Indicator {
    static className: string;
    static classNames: Array<string>;
    _settings: IVolumeProfileSettings;
    _privateSettings: IVolumeProfilePrivate;
    _events: IVolumeProfileEvents;
    /**
     * Indicator series.
     */
    series: ColumnSeries;
    _editableSettings: IIndicatorEditableSetting[];
    xAxis: ValueAxis<AxisRendererX>;
    upSeries: ColumnSeries;
    protected _previousColumn?: Graphics;
    protected _afterNew(): void;
    protected _addInteractivity(series: ColumnSeries): void;
    _updateChildren(): void;
    /**
     * @ignore
     */
    prepareData(): void;
    protected _dispose(): void;
}
//# sourceMappingURL=VolumeProfile.d.ts.map