import { Indicator, IIndicatorSettings, IIndicatorPrivate, IIndicatorEvents, IIndicatorEditableSetting } from "./Indicator";
import { LineSeries } from "../../xy/series/LineSeries";
import type { Color } from "../../../core/util/Color";
import type { DataItem } from "../../../..";
export interface ISuperTrendSettings extends IIndicatorSettings {
    upperColor?: Color;
    lowerColor?: Color;
    multiplier?: number;
}
export interface ISuperTrendPrivate extends IIndicatorPrivate {
}
export interface ISuperTrendEvents extends IIndicatorEvents {
}
/**
 * An implementation of a [[StockChart]] indicator.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/stock/indicators/} for more info
 */
export declare class SuperTrend extends Indicator {
    static className: string;
    static classNames: Array<string>;
    _settings: ISuperTrendSettings;
    _privateSettings: ISuperTrendPrivate;
    _events: ISuperTrendEvents;
    /**
     * Indicator series for the upper band.
     */
    upperBandSeries: LineSeries;
    /**
     * Indicator series for the lower band.
     */
    lowerBandSeries: LineSeries;
    /**
     * Indicator series.
     */
    series: LineSeries;
    _editableSettings: IIndicatorEditableSetting[];
    protected _afterNew(): void;
    _updateChildren(): void;
    protected _getDataArray(dataItems: Array<DataItem<any>>): Array<any>;
    /**
     * @ignore
     */
    prepareData(): void;
    protected _dispose(): void;
    hide(duration?: number): Promise<any>;
    show(duration?: number): Promise<any>;
}
//# sourceMappingURL=SuperTrend.d.ts.map